/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.module.impl.TickTaskExecutor;

public interface ChunkHighlightCache {
    public void addHighlight(int var1, int var2);

    public void addHighlight(int var1, int var2, ResourceKey<Level> var3);

    public void removeHighlight(int var1, int var2);

    public void removeHighlight(int var1, int var2, ResourceKey<Level> var3);

    public boolean isHighlighted(int var1, int var2, ResourceKey<Level> var3);

    public Long2LongMap getCacheMap(ResourceKey<Level> var1);

    public CompletableFuture<Long2LongMap> getHighlightsInCustomWindow(int var1, int var2, int var3, ResourceKey<Level> var4);

    public void handleWorldChange(XaeroWorldChangeEvent var1);

    public void handleTick();

    public void onEnable();

    public void onDisable();

    default public <V> CompletableFuture<V> submitTickTask(Supplier<V> task) {
        return TickTaskExecutor.INSTANCE.submit(task);
    }

    default public CompletableFuture<Void> submitTickTask(Runnable task) {
        return TickTaskExecutor.INSTANCE.submit(task);
    }
}

