/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ForgeMessageUtils
extends MessageUtils {
    private static final DefaultedRegistry<Item> itemreg = BuiltInRegistries.f_257033_;

    public static String formatPlayerName(Map.Entry<UUID, String> p) {
        return ForgeMessageUtils.formatPlayerName(p, true);
    }

    public static String formatPlayerName(Map.Entry<UUID, String> p, boolean chatFormat) {
        return ChatFormatting.m_126649_((String)p.getValue());
    }

    public static MessageEmbed genItemStackEmbedIfAvailable(Component component) {
        JsonObject json;
        if (!Configuration.instance().forgeSpecific.sendItemInfo) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)Component.Serializer.m_130703_((Component)component));
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            json = jsonElement.getAsJsonObject();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            return null;
        }
        if (json.has("with")) {
            JsonArray args2 = json.getAsJsonArray("with");
            for (JsonElement el : args2) {
                JsonObject hoverEvent;
                JsonObject arg1;
                if (!(el instanceof JsonObject) || !(arg1 = (JsonObject)el).has("hoverEvent") || !(hoverEvent = arg1.getAsJsonObject("hoverEvent")).has("action") || !hoverEvent.get("action").getAsString().equals("show_item") || !hoverEvent.has("contents") || !hoverEvent.getAsJsonObject("contents").has("tag")) continue;
                JsonObject item = hoverEvent.getAsJsonObject("contents").getAsJsonObject();
                try {
                    String title;
                    ItemStack is = new ItemStack((ItemLike)itemreg.m_7745_(new ResourceLocation(item.get("id").getAsString())));
                    if (item.has("tag")) {
                        CompoundTag tag = (CompoundTag)NbtTagArgument.m_100659_().parse(new StringReader(item.get("tag").getAsString()));
                        is.m_41751_(tag);
                    }
                    CompoundTag itemTag = is.m_41784_();
                    EmbedBuilder b = new EmbedBuilder();
                    String string = title = is.m_41788_() ? is.m_41611_().getString() : is.m_41720_().m_41466_().getString();
                    if (title.isEmpty()) {
                        title = is.m_41720_().m_5524_();
                    } else {
                        b.setFooter(is.m_41720_().m_5524_());
                    }
                    b.setTitle(title);
                    StringBuilder tooltip = new StringBuilder();
                    boolean[] flags = new boolean[6];
                    Arrays.fill(flags, false);
                    if (itemTag.m_128441_("HideFlags")) {
                        int input = itemTag.m_128451_("HideFlags");
                        for (int i = 0; i < flags.length; ++i) {
                            flags[i] = (input & 1 << i) != 0;
                        }
                    }
                    if (!flags[0]) {
                        EnchantmentHelper.m_44831_((ItemStack)is).forEach((ench, lvl) -> tooltip.append(ChatFormatting.m_126649_((String)ench.m_44700_(lvl.intValue()).getString())).append("\n"));
                    }
                    ListTag list = itemTag.m_128469_("display").m_128437_("Lore", 8);
                    list.forEach(nbt -> {
                        try {
                            if (nbt instanceof StringTag) {
                                Component comp = ComponentArgument.m_87114_().parse(new StringReader(nbt.m_7916_()));
                                tooltip.append("_").append(comp.getString()).append("_\n");
                            }
                        }
                        catch (CommandSyntaxException e) {
                            e.printStackTrace();
                        }
                    });
                    if (!flags[2] && itemTag.m_128441_("Unbreakable") && itemTag.m_128471_("Unbreakable")) {
                        tooltip.append("Unbreakable\n");
                    }
                    b.setDescription(tooltip.toString());
                    return b.build();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                }
            }
        }
        return null;
    }

    public static String formatPlayerName(Entity p) {
        DefaultMapEntry<UUID, ComponentContents> e = new DefaultMapEntry<UUID, ComponentContents>(p.m_20148_(), (ComponentContents)(p.m_5446_().getString().isEmpty() ? p.m_7755_().m_214077_() : p.m_5446_().getString()));
        return ForgeMessageUtils.formatPlayerName(e);
    }
}

