/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.compat;

import dcshadow.org.jetbrains.annotations.NotNull;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.api.DiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;

public class DynmapListener
extends DynmapCommonAPIListener {
    private final boolean workaroundEnabled;
    private final DynmapSender sender = new DynmapSender();
    private DynmapCommonAPI api;

    public DynmapListener() {
        this.workaroundEnabled = false;
    }

    public DynmapListener(boolean workaroundEnabled) {
        this.workaroundEnabled = workaroundEnabled;
    }

    public void apiEnabled(DynmapCommonAPI api) {
        this.api = api;
        if (DiscordIntegration.INSTANCE != null) {
            DiscordIntegration.INSTANCE.registerEventHandler(this.sender);
        }
        DiscordIntegration.LOGGER.info("Dynmap listener registered");
    }

    public void apiDisabled(DynmapCommonAPI api) {
        if (DiscordIntegration.INSTANCE != null) {
            DiscordIntegration.INSTANCE.unregisterEventHandler(this.sender);
        }
    }

    public boolean webChatEvent(String source2, String name, String message) {
        if (!this.workaroundEnabled) {
            this.sendMessage(name, message);
        }
        return super.webChatEvent(source2, name, message);
    }

    public void sendMessage(String name, String message) {
        DiscordIntegration.INSTANCE.sendMessage(DiscordIntegration.INSTANCE.getChannel(Configuration.instance().dynmap.dynmapChannelID), Configuration.instance().dynmap.dcMessage.replace("%msg%", message).replace("%sender%", name.isEmpty() ? Configuration.instance().dynmap.unnamed : name), Configuration.instance().dynmap.avatarURL, Configuration.instance().dynmap.name);
    }

    public void register() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)this);
    }

    public class DynmapSender
    extends DiscordEventHandler {
        @Override
        public void onDiscordMessagePost(@NotNull MessageReceivedEvent event) {
            if (event.getChannel().getId().equals(Configuration.instance().dynmap.dynmapChannelID.equals("default") ? Configuration.instance().general.botChannel : Configuration.instance().dynmap.dynmapChannelID)) {
                DynmapListener.this.api.sendBroadcastToWeb(Configuration.instance().dynmap.webName.replace("%name#tag%", event.getAuthor().getAsTag()).replace("%name%", event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName()), event.getMessage().getContentDisplay());
            }
        }
    }
}

