/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.addon;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.com.moandjiezana.toml.TomlWriter;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordIntegrationAddon;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class AddonConfigRegistry {
    public static <T> T loadConfig(T cfg, File configFile) {
        if (configFile == null) {
            return null;
        }
        if (!configFile.exists()) {
            AddonConfigRegistry.saveConfig(cfg, configFile);
        }
        Object conf = new Toml().read(configFile).to(cfg.getClass());
        AddonConfigRegistry.saveConfig(conf, configFile);
        return (T)conf;
    }

    public static <T> void saveConfig(T cfg, File configFile) {
        if (configFile == null) {
            return;
        }
        try {
            if (!configFile.exists()) {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                configFile.createNewFile();
            }
            TomlWriter w = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(2).build();
            w.write(cfg, configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> T loadConfig(Class<T> cfg, DiscordIntegrationAddon inst) {
        try {
            T conf = cfg.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return AddonConfigRegistry.loadConfig(conf, inst);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            DiscordIntegration.LOGGER.error("An exception occurred while loading addon configuration " + cfg.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T loadConfig(T cfg, DiscordIntegrationAddon inst) {
        return AddonConfigRegistry.loadConfig(cfg, new File(AddonLoader.getAddonDir(), AddonLoader.getAddonMeta(inst).getName() + ".toml"));
    }
}

