/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.org.apache.commons.collections4.iterators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class PushbackIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Deque<E> items = new ArrayDeque();

    public static <E> PushbackIterator<E> pushbackIterator(Iterator<? extends E> iterator2) {
        if (iterator2 == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (iterator2 instanceof PushbackIterator) {
            PushbackIterator it = (PushbackIterator)iterator2;
            return it;
        }
        return new PushbackIterator<E>(iterator2);
    }

    public PushbackIterator(Iterator<? extends E> iterator2) {
        this.iterator = iterator2;
    }

    public void pushback(E item) {
        this.items.push(item);
    }

    @Override
    public boolean hasNext() {
        return !this.items.isEmpty() || this.iterator.hasNext();
    }

    @Override
    public E next() {
        return !this.items.isEmpty() ? this.items.pop() : this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

