/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash.api.modloader.forge;

import java.util.HashMap;
import java.util.Optional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeModLoader {
    private static final HashMap<String, ModLoadingContext> MOD_CONTEXTS = new HashMap();
    private static final HashMap<String, FMLJavaModLoadingContext> FML_MOD_CONTEXTS = new HashMap();

    public static void registerMod(String modId, ModLoadingContext context, FMLJavaModLoadingContext fmlContext) {
        MOD_CONTEXTS.put(modId, context);
        FML_MOD_CONTEXTS.put(modId, fmlContext);
    }

    public static Optional<ModLoadingContext> getContext(String modId) {
        return Optional.ofNullable(MOD_CONTEXTS.get(modId));
    }

    public static ModLoadingContext getContextOrThrow(String modId) {
        return ForgeModLoader.getContext(modId).orElseThrow(() -> new NullPointerException("Forge Mod " + modId + " has not been registered to Ash."));
    }

    public static Optional<IEventBus> getEventBus(String modId) {
        return Optional.ofNullable(FML_MOD_CONTEXTS.get(modId)).map(FMLJavaModLoadingContext::getModEventBus);
    }

    public static IEventBus getEventBusOrThrow(String modId) {
        return ForgeModLoader.getEventBus(modId).orElseThrow(() -> new NullPointerException("Forge Mod " + modId + " has not been registered to Ash."));
    }
}

