/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.StationTagSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.TransferOwnershipWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutColorPicker;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutPlayerList;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.SimpleDataListNewEntry;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;

public class GlobalSettingsScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private DLOptionsList viewer;
    private ModStationSuggestions destinationSuggestions;
    private final Component optionTagTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.title");
    private final Component optionTagDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.title");
    private final Component optionBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainCategoryTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_category.title");
    private final Component optionTrainCategoryDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_category.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.title");
    private final Component optionTrainBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainLineTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.title");
    private final Component optionTrainLineDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.description").m_130940_(ChatFormatting.GRAY);
    private final Component textColor = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.color");
    private final List<String> stationNames = new ArrayList<String>();
    private final List<String> trainNames = new ArrayList<String>();

    public GlobalSettingsScreen(Screen lastScreen) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.title").m_7220_((Component)(GlobalSettingsClient.modificationsAllowed() ? TextUtils.empty() : TextUtils.text((String)" ").m_7220_(Constants.TEXT_READ_ONLY).m_130940_(ChatFormatting.DARK_RED))), CreateDynamicWidgets.BarColor.GRAY);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        super.m_86600_();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.destinationSuggestions.getEditBox().m_94204_()) {
                this.clearSuggestions();
            }
        });
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.setAllowedLayer(0);
        DLCreateIconButton helpButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Global-Settings");
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TEXT_HELP).assignedTo((AbstractWidget)helpButton));
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1;
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.guiLeft + 240 - 8, this.guiTop + dy, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new DLOptionsList((Screen)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.m_142416_((GuiEventListener)this.viewer);
        this.m_142416_((GuiEventListener)scrollBar);
        this.viewer.addOption(null, this.optionTagTitle, this.optionTagDescription, (a, b) -> Minecraft.m_91087_().m_91152_((Screen)new StationTagSettingsScreen((Screen)this)), null);
        GlobalSettingsClient.getBlacklistedStations(datalist -> {
            this.addBlacklistedStationsWidget(datalist.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList(), scrollBar);
            GlobalSettingsClient.getBlacklistedTrains(datalist2 -> {
                this.addBlacklistedTrainsWidget(datalist2.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList(), scrollBar);
                GlobalSettingsClient.getTrainCategories(datalist3 -> {
                    this.addTrainCategoriesWidget(datalist3.stream().sorted((a, b) -> a.getCategoryName().compareToIgnoreCase(b.getCategoryName())).toList(), scrollBar);
                    GlobalSettingsClient.getTrainLines(datalist4 -> this.addTrainLinesWidget(datalist4.stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).toList(), scrollBar));
                });
            });
        });
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_TRAIN_NAMES, names -> {
            this.trainNames.clear();
            this.trainNames.addAll((Collection<String>)names);
            DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_NAMES, names2 -> {
                this.stationNames.clear();
                this.stationNames.addAll((Collection<String>)names2);
            });
        });
    }

    private void addBlacklistedStationsWidget(List<String> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, String> cont = new DataListContainer<Collection, String>((OptionEntry<?>)option, workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).iterator(), (data, entryWidget) -> {
                if (!GlobalSettingsClient.modificationsAllowed()) {
                    return data;
                }
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> {
                    FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> GlobalSettingsClient.removeStationFromBlacklist(entry, res -> refreshAction.accept(Optional.ofNullable(res))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0));
                    dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                    dlg.open((IDragonLibWidget)btn);
                });
                return data;
            }, (BiConsumer<Collection, SimpleDataListNewEntry<Collection, String>>)(GlobalSettingsClient.modificationsAllowed() ? (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), List.of(Constants.TEXT_ADD), (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.addStationToBlacklist(name, res -> refreshAction.accept(Optional.ofNullable(res)));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.m_94151_(b -> this.updateEditorSubwidgetsStations((DLEditBox)box, (Collection<String>)data));
                    box.m_94199_(32);
                });
            } : null), self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionBlacklistTitle, this.optionBlacklistDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), List.of(Constants.TEXT_HELP), (entry, btn) -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Blacklist"));
    }

    private void addBlacklistedTrainsWidget(List<String> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, String> cont = new DataListContainer<Collection, String>((OptionEntry<?>)option, workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).iterator(), (data, entryWidget) -> {
                if (!GlobalSettingsClient.modificationsAllowed()) {
                    return data;
                }
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> {
                    FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> GlobalSettingsClient.removeTrainFromBlacklist(entry, res -> refreshAction.accept(Optional.ofNullable(res))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0));
                    dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                    dlg.open((IDragonLibWidget)btn);
                });
                return data;
            }, (BiConsumer<Collection, SimpleDataListNewEntry<Collection, String>>)(GlobalSettingsClient.modificationsAllowed() ? (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), List.of(Constants.TEXT_ADD), (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.addTrainToBlacklist(name, res -> refreshAction.accept(Optional.ofNullable(res)));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.m_94151_(b -> this.updateEditorSubwidgetsTrains((DLEditBox)box, (Collection<String>)data));
                    box.m_94199_(32);
                });
            } : null), self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainBlacklistTitle, this.optionTrainBlacklistDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), List.of(Constants.TEXT_HELP), (entry, btn) -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Blacklist"));
    }

    private void addTrainCategoriesWidget(List<TrainCategory> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, TrainCategory> cont = new DataListContainer<Collection, TrainCategory>((OptionEntry<?>)option, workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.getCategoryName().compareToIgnoreCase(b.getCategoryName())).iterator(), (data, entryWidget) -> {
                if (!GlobalSettingsClient.modificationsAllowed()) {
                    return data.getCategoryName();
                }
                if (data.getOwner().isAllowed()) {
                    entryWidget.setOnEditName((tg, entry, newValue, refreshAction) -> {
                        if (!newValue.isBlank() && !entry.getCategoryName().equals(newValue)) {
                            GlobalSettingsClient.updateTrainCategoryName(entry.getId(), newValue, x -> GlobalSettingsClient.getTrainCategories(res -> refreshAction.accept(Optional.ofNullable(res))));
                        }
                    });
                    entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> {
                        FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> GlobalSettingsClient.deleteTrainCategory(entry.getId(), () -> GlobalSettingsClient.getTrainCategories(res -> refreshAction.accept(Optional.ofNullable(res)))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0));
                        dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                        dlg.open((IDragonLibWidget)btn);
                    });
                    DLIconButton colorBtn = entryWidget.addButton(ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16), List.of(this.textColor), (btn, tg, entry, refreshAction) -> {
                        TrainCategory e = entry;
                        FlyoutColorPicker<GuiEventListener> flyout = new FlyoutColorPicker<GuiEventListener>(this, e.getColor(), Constants.DEFAULT_TRAIN_TYPE_COLORS, 5, true, true, x$0 -> this.m_142416_((GuiEventListener)x$0), w -> {
                            GlobalSettingsClient.updateTrainCategoryColor(e.getId(), ((FlyoutColorPicker)((Object)((Object)((Object)((Object)w))))).getColorPicker().getSelectedColor(), () -> GlobalSettingsClient.getTrainCategories(res -> refreshAction.accept(Optional.ofNullable(res))));
                            this.m_169411_((GuiEventListener)w);
                        });
                        flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                        flyout.open((IDragonLibWidget)btn);
                    });
                    colorBtn.setBackColor(data.getColor());
                }
                DLIconButton btnPermissions = entryWidget.addButton(data.getOwner().get().getIcon(), data.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), (btn, tg, entry, refreshAction) -> {
                    if (!data.getOwner().isAllowed()) {
                        return;
                    }
                    GlobalSettingsClient.updateTrainCategoryPermissions(new Lock.PermissionsUpdateData(entry.getId(), null, (Lock.LockState)entry.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                        data.getOwner().set(x.getOwner().get());
                        data.getOwner().updateTrusted(x.getOwner().getTrusted());
                        btn.setSprite(x.getOwner().get().getIcon());
                        entryWidget.updateTooltipOf((DLIconButton)btn, x.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)));
                    }));
                });
                if (data.getOwner().isAdmin()) {
                    btnPermissions.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)btnPermissions), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), Sprite.empty(), true, b -> {
                        FlyoutPlayerList<GuiEventListener> flyout = new FlyoutPlayerList<GuiEventListener>(this, this::updateEditorSubwidgetsOnlinePlayers, data.getOwner().getTrusted(), x$0 -> this.m_142416_((GuiEventListener)x$0), w -> {
                            GlobalSettingsClient.updateTrainCategoryPermissions(new Lock.PermissionsUpdateData(data.getId(), null, null, ((FlyoutPlayerList)((Object)((Object)((Object)((Object)((Object)w)))))).getPlayerList().getPlayers()), $ -> GlobalSettingsClient.getTrainCategories(res -> entryWidget.getParent().displayData((List)res)));
                            this.m_169411_((GuiEventListener)w);
                        });
                        flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                        flyout.open((IDragonLibWidget)btnPermissions);
                    }, null)).add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), Sprite.empty(), true, b -> this.m_142416_((GuiEventListener)new TransferOwnershipWidget<GuiEventListener>(this, data.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateTrainCategoryPermissions(new Lock.PermissionsUpdateData(data.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getTrainCategories(res -> entryWidget.getParent().displayData((List)res))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0))), null))));
                }
                return data.getCategoryName();
            }, GlobalSettingsClient.modificationsAllowed() ? (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), List.of(Constants.TEXT_ADD), (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.createTrainCategory(name, res -> GlobalSettingsClient.getTrainCategories(r -> refreshAction.accept(Optional.ofNullable(r))));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.m_94151_(b -> {});
                    box.m_94199_(32);
                });
            } : null, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.getCategoryName().toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainCategoryTitle, this.optionTrainCategoryDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), List.of(Constants.TEXT_HELP), (entry, btn) -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Categories"));
    }

    private void addTrainLinesWidget(List<TrainLine> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, TrainLine> cont = new DataListContainer<Collection, TrainLine>((OptionEntry<?>)option, workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).iterator(), (data, entryWidget) -> {
                if (!GlobalSettingsClient.modificationsAllowed()) {
                    return data.getLineName();
                }
                if (data.getOwner().isAllowed()) {
                    entryWidget.setOnEditName((tg, entry, newValue, refreshAction) -> {
                        if (!newValue.isBlank() && !entry.getLineName().equals(newValue)) {
                            GlobalSettingsClient.updateTrainLineName(entry.getId(), newValue, x -> GlobalSettingsClient.getTrainLines(res -> refreshAction.accept(Optional.ofNullable(res))));
                        }
                    });
                    entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> {
                        FlyoutConfirmDialog<GuiEventListener> dlg = new FlyoutConfirmDialog<GuiEventListener>(this, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> GlobalSettingsClient.deleteTrainLine(entry.getId(), () -> GlobalSettingsClient.getTrainLines(res -> refreshAction.accept(Optional.ofNullable(res)))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0));
                        dlg.setYOffset((int)(-scrollBar.getScrollValue()));
                        dlg.open((IDragonLibWidget)btn);
                    });
                    DLIconButton colorBtn = entryWidget.addButton(ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16), List.of(this.textColor), (btn, tg, entry, refreshAction) -> {
                        TrainLine e = entry;
                        FlyoutColorPicker<GuiEventListener> flyout = new FlyoutColorPicker<GuiEventListener>(this, e.getColor(), Constants.DEFAULT_TRAIN_TYPE_COLORS, 5, true, true, x$0 -> this.m_142416_((GuiEventListener)x$0), w -> {
                            GlobalSettingsClient.updateTrainLineColor(e.getId(), ((FlyoutColorPicker)((Object)((Object)((Object)((Object)w))))).getColorPicker().getSelectedColor(), () -> GlobalSettingsClient.getTrainLines(res -> refreshAction.accept(Optional.ofNullable(res))));
                            this.m_169411_((GuiEventListener)w);
                        });
                        flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                        flyout.open((IDragonLibWidget)btn);
                    });
                    colorBtn.setBackColor(data.getColor());
                }
                DLIconButton btnPermissions = entryWidget.addButton(data.getOwner().get().getIcon(), data.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), (btn, tg, entry, refreshAction) -> {
                    if (!data.getOwner().isAllowed()) {
                        return;
                    }
                    GlobalSettingsClient.updateTrainLinePermissions(new Lock.PermissionsUpdateData(entry.getId(), null, (Lock.LockState)entry.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                        data.getOwner().set(x.getOwner().get());
                        data.getOwner().updateTrusted(x.getOwner().getTrusted());
                        btn.setSprite(x.getOwner().get().getIcon());
                        entryWidget.updateTooltipOf((DLIconButton)btn, x.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)));
                    }));
                });
                if (data.getOwner().isAdmin()) {
                    btnPermissions.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)btnPermissions), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), Sprite.empty(), true, b -> {
                        FlyoutPlayerList<GuiEventListener> flyout = new FlyoutPlayerList<GuiEventListener>(this, this::updateEditorSubwidgetsOnlinePlayers, data.getOwner().getTrusted(), x$0 -> this.m_142416_((GuiEventListener)x$0), w -> {
                            GlobalSettingsClient.updateTrainLinePermissions(new Lock.PermissionsUpdateData(data.getId(), null, null, ((FlyoutPlayerList)((Object)((Object)((Object)((Object)((Object)w)))))).getPlayerList().getPlayers()), $ -> GlobalSettingsClient.getTrainLines(res -> entryWidget.getParent().displayData((List)res)));
                            this.m_169411_((GuiEventListener)w);
                        });
                        flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                        flyout.open((IDragonLibWidget)btnPermissions);
                    }, null)).add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), Sprite.empty(), true, b -> this.m_142416_((GuiEventListener)new TransferOwnershipWidget<GuiEventListener>(this, data.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateTrainLinePermissions(new Lock.PermissionsUpdateData(data.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getTrainLines(res -> entryWidget.getParent().displayData((List)res))), x$0 -> this.m_142416_((GuiEventListener)x$0), arg_0 -> ((GlobalSettingsScreen)this).m_169411_(arg_0))), null))));
                }
                return data.getLineName();
            }, GlobalSettingsClient.modificationsAllowed() ? (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), List.of(Constants.TEXT_ADD), (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.createTrainLine(name, res -> GlobalSettingsClient.getTrainLines(r -> refreshAction.accept(Optional.ofNullable(r))));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.m_94151_(b -> {});
                    box.m_94199_(32);
                });
            } : null, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.getLineName().toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainLineTitle, this.optionTrainLineDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), List.of(Constants.TEXT_HELP), (entry, btn) -> Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Lines"));
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int h = 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size();
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, h + 1, CreateDynamicWidgets.ContainerColor.PURPLE);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(-this.viewer.getXScrollOffset(), -this.viewer.getYScrollOffset(), 0.0);
            x.render(graphics.graphics(), (int)((double)mouseX + this.viewer.getXScrollOffset()), (int)((double)mouseY + this.viewer.getYScrollOffset()));
            graphics.poseStack().m_85849_();
        });
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), MathUtils.clamp((double)delta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().m_94167_("");
        }
        this.destinationSuggestions = null;
    }

    public void updateEditorSubwidgetsTrains(DLEditBox field, Collection<String> blacklisted) {
        this.updateEditorSubwidgetsInternal(field, this.getViableTrains(this.trainNames, blacklisted));
    }

    public void updateEditorSubwidgetsStations(DLEditBox field, Collection<String> blacklisted) {
        this.updateEditorSubwidgetsInternal(field, this.getViableStations(this.stationNames, blacklisted));
    }

    public void updateEditorSubwidgetsOnlinePlayers(DLEditBox field, Collection<Owner> src, Collection<Owner> list) {
        this.updateEditorSubwidgetsInternal(field, this.getViablePlayers(src, list));
    }

    private void updateEditorSubwidgetsInternal(DLEditBox field, List<String> data) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModStationSuggestions(Minecraft.m_91087_(), (Screen)this, (EditBox)field, this.f_96547_, data, field.m_93694_() + 2 + field.m_252907_());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(Collection<String> src, Collection<String> blacklisted) {
        return src.stream().distinct().filter(x -> !blacklisted.contains(x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    private List<String> getViableTrains(Collection<String> src, Collection<String> blacklisted) {
        return src.stream().distinct().filter(x -> !blacklisted.contains(x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    private List<String> getViablePlayers(Collection<Owner> src, Collection<Owner> list) {
        return src.stream().distinct().filter(x -> !list.contains(x)).map(Owner::name).toList();
    }

    @FunctionalInterface
    public static interface IPlayerListSuggestionData {
        public void run(DLEditBox var1, Collection<Owner> var2, Collection<Owner> var3);
    }
}

