/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.lixir.vminus.NumberUtil;
import net.lixir.vminus.visions.VisionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class VisionValueHandler {
    private static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static double applyOperations(int initialValue, JsonArray valueArray, @Nullable ItemStack itemstack) {
        int modifiedValue = initialValue;
        for (JsonElement element : valueArray) {
            JsonObject durabilityData = element.getAsJsonObject();
            if (!VisionValueHandler.checkConditions(durabilityData, itemstack) || !durabilityData.has("value")) continue;
            int value = durabilityData.get("value").getAsInt();
            String operation = "set";
            if (durabilityData.has("operation")) {
                operation = durabilityData.get("operation").getAsString() != null ? durabilityData.get("operation").getAsString() : "set";
            }
            modifiedValue = (int)NumberUtil.modifyNumber(modifiedValue, value, operation);
        }
        return modifiedValue;
    }

    public static FoodProperties getFoodProperties(JsonObject itemData, @Nullable ItemStack itemstack, @Nullable FoodProperties defaultProperties) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        if (itemData != null && itemData.has("food_properties")) {
            JsonArray foodPropertiesArray = itemData.getAsJsonArray("food_properties");
            for (JsonElement element : foodPropertiesArray) {
                JsonObject foodProperties = element.getAsJsonObject();
                if (VisionValueHandler.checkConditions(foodProperties, itemstack)) {
                    if (foodProperties.has("nutrition")) {
                        builder.m_38760_(foodProperties.get("nutrition").getAsInt());
                    } else if (defaultProperties != null) {
                        builder.m_38760_(defaultProperties.m_38744_());
                    } else {
                        builder.m_38760_(0);
                    }
                    if (foodProperties.has("saturation")) {
                        builder.m_38758_(foodProperties.get("saturation").getAsFloat());
                    } else if (defaultProperties != null) {
                        builder.m_38758_(defaultProperties.m_38745_());
                    } else {
                        builder.m_38758_(0.0f);
                    }
                    if (foodProperties.has("is_meat") && foodProperties.get("is_meat").getAsBoolean()) {
                        builder.m_38757_();
                    }
                    if (foodProperties.has("can_always_eat") && foodProperties.get("can_always_eat").getAsBoolean()) {
                        builder.m_38765_();
                    }
                    if (foodProperties.has("fast_food") && foodProperties.get("fast_food").getAsBoolean()) {
                        builder.m_38766_();
                    }
                    if (!foodProperties.has("effects")) continue;
                    JsonArray effectsArray = foodProperties.getAsJsonArray("effects");
                    for (JsonElement effectElement : effectsArray) {
                        String effectId;
                        MobEffect effect;
                        JsonObject effectData = effectElement.getAsJsonObject();
                        if (!VisionValueHandler.checkConditions(effectData, itemstack) || !effectData.has("effect_id") || !effectData.has("amplifier") || !effectData.has("duration") || (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId = effectData.get("effect_id").getAsString()))) == null) continue;
                        int value = effectData.get("amplifier").getAsInt();
                        int duration = effectData.get("duration").getAsInt();
                        float chance = 1.0f;
                        if (effectData.has("chance")) {
                            chance = effectData.get("chance").getAsFloat();
                        }
                        builder.m_38762_(new MobEffectInstance(effect, duration, value), chance);
                    }
                    continue;
                }
                return defaultProperties;
            }
        }
        return builder.m_38767_();
    }

    public static <T extends Number> T isNumberMet(@Nullable JsonObject visionData, String checkFor, T defaultValue) {
        return VisionValueHandler.isNumberMet(visionData, checkFor, defaultValue, null, null, null);
    }

    public static <T extends Number> T isNumberMet(@Nullable JsonObject visionData, String checkFor, T defaultValue, Block block) {
        return VisionValueHandler.isNumberMet(visionData, checkFor, defaultValue, null, block, null);
    }

    public static <T extends Number> T isNumberMet(@Nullable JsonObject visionData, String checkFor, T defaultValue, ItemStack itemstack) {
        return VisionValueHandler.isNumberMet(visionData, checkFor, defaultValue, itemstack, null, null);
    }

    public static <T extends Number> T isNumberMet(@Nullable JsonObject visionData, String checkFor, T defaultValue, Entity entity) {
        return VisionValueHandler.isNumberMet(visionData, checkFor, defaultValue, null, null, entity);
    }

    public static <T extends Number> T isNumberMet(@Nullable JsonObject visionData, String checkFor, T defaultValue, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity) {
        T result = defaultValue;
        if (VisionValueHandler.checkValidParams(visionData = VisionValueHandler.getVisionData(visionData, itemstack, block, entity), checkFor).booleanValue()) {
            JsonArray numberArray = visionData.getAsJsonArray(checkFor);
            for (JsonElement element : numberArray) {
                JsonObject numberData = element.getAsJsonObject();
                if (!VisionValueHandler.checkConditions(numberData, itemstack, block, entity) || !numberData.has("value")) continue;
                T value = VisionValueHandler.convertToNumber(numberData.get("value").getAsString(), defaultValue);
                String operation = numberData.has("operation") ? numberData.get("operation").getAsString() : "set";
                result = VisionValueHandler.modifyNumberAsType(result, value, operation);
            }
        }
        return result;
    }

    private static <T extends Number> T modifyNumberAsType(T result, T value, String operation) {
        if (result instanceof Integer) {
            return (T)Integer.valueOf((int)NumberUtil.modifyNumber(result.intValue(), value.intValue(), operation));
        }
        if (result instanceof Double) {
            return (T)Double.valueOf(NumberUtil.modifyNumber(result.doubleValue(), value.doubleValue(), operation));
        }
        if (result instanceof Long) {
            return (T)Long.valueOf((long)NumberUtil.modifyNumber(result.longValue(), value.longValue(), operation));
        }
        if (result instanceof Short) {
            return (T)Short.valueOf((short)NumberUtil.modifyNumber(result.shortValue(), value.shortValue(), operation));
        }
        if (result instanceof Float) {
            return (T)Float.valueOf((float)NumberUtil.modifyNumber(result.floatValue(), value.floatValue(), operation));
        }
        if (result instanceof Byte) {
            return (T)Byte.valueOf((byte)NumberUtil.modifyNumber(result.byteValue(), value.byteValue(), operation));
        }
        throw new IllegalArgumentException("Unsupported number type: " + result.getClass());
    }

    private static <T extends Number> T convertToNumber(String value, T defaultValue) {
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(value);
        }
        if (defaultValue instanceof Double) {
            return (T)Double.valueOf(value);
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(value);
        }
        if (defaultValue instanceof Short) {
            return (T)Short.valueOf(value);
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(value);
        }
        if (defaultValue instanceof Byte) {
            return (T)Byte.valueOf(value);
        }
        throw new IllegalArgumentException("Unsupported number type: " + defaultValue.getClass());
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, null, "value", null, null, null);
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor, ItemStack itemstack) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, itemstack, "value", null, null, null);
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor, ItemStack itemstack, String param) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, itemstack, param, null, null, null);
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor, Block block) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, null, "value", block, null, null);
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor, Entity entity) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, null, "value", null, entity, null);
    }

    public static boolean isBooleanMet(@Nullable JsonObject itemData, String checkFor, EntityType<?> entityType) {
        return VisionValueHandler.isBooleanMet(itemData, checkFor, null, "value", null, null, entityType);
    }

    public static boolean isBooleanMet(@Nullable JsonObject visionData, String checkFor, @Nullable ItemStack itemstack, @Nullable String param, @Nullable Block block, @Nullable Entity entity, @Nullable EntityType<?> entityType) {
        boolean booleanResult = false;
        if (VisionValueHandler.checkValidParams(visionData = VisionValueHandler.getVisionData(visionData, itemstack, block, entity, entityType), checkFor).booleanValue()) {
            JsonArray jsonData = visionData.getAsJsonArray(checkFor);
            for (JsonElement element : jsonData) {
                JsonObject conditionData = element.getAsJsonObject();
                if (!VisionValueHandler.checkConditions(conditionData, itemstack, block, entity) || !conditionData.has(param)) continue;
                boolean value = conditionData.get(param).getAsBoolean();
                return value;
            }
        }
        return booleanResult;
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable JsonObject visionData, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity) {
        return VisionValueHandler.getVisionData(visionData, itemstack, block, entity, null);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable JsonObject visionData, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity, @Nullable EntityType<?> entityType) {
        if (visionData != null) {
            return visionData;
        }
        if (itemstack != null) {
            visionData = VisionHandler.getVisionData(itemstack);
        }
        if (block != null) {
            visionData = VisionHandler.getVisionData(block);
        }
        if (entity != null) {
            visionData = VisionHandler.getVisionData(entity.m_6095_());
        } else if (entityType != null) {
            visionData = VisionHandler.getVisionData(entityType);
        }
        return visionData;
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, Entity entity, String param) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, null, null, entity, param);
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, Block block, String param) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, null, block, null, param);
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, ItemStack itemstack, String param) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, itemstack, null, null, param);
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, Entity entity) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, null, null, entity, "value");
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, Block block) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, null, block, null, "value");
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, ItemStack itemstack) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, itemstack, null, null, "value");
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor) {
        return VisionValueHandler.getFirstValidString(visionData, checkFor, null, null, null, "value");
    }

    @Nullable
    public static String getFirstValidString(@Nullable JsonObject visionData, String checkFor, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity, @Nullable String param) {
        if (VisionValueHandler.checkValidParams(visionData = VisionValueHandler.getVisionData(visionData, itemstack, block, entity), checkFor).booleanValue()) {
            JsonArray conditionArray = visionData.getAsJsonArray(checkFor);
            for (JsonElement element : conditionArray) {
                JsonObject elementObject = element.getAsJsonObject();
                if (!VisionValueHandler.checkConditions(elementObject, itemstack, block, entity) || !elementObject.has(param)) continue;
                return elementObject.get(param).getAsString();
            }
        }
        return null;
    }

    public static Boolean checkValidParams(@Nullable JsonObject itemData, @Nullable String param) {
        if (itemData != null) {
            return itemData.has(param);
        }
        return false;
    }

    public static boolean matchItemList(@Nullable JsonObject visionData, String checkFor, @Nullable ItemStack itemstack) {
        if (visionData == null || itemstack == null || !visionData.has(checkFor)) {
            return false;
        }
        JsonArray itemArray = visionData.getAsJsonArray(checkFor);
        for (JsonElement element : itemArray) {
            String tag;
            String value = element.getAsString();
            if (!(value.startsWith("#") ? itemstack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag = value.substring(1)))) : ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_()).toString().equals(value))) continue;
            return true;
        }
        return false;
    }

    public static boolean EnchantmentCompatibleWith(@Nullable JsonObject visionData, Enchantment thisEnchantment, Enchantment otherEnchantment) {
        if (thisEnchantment == otherEnchantment) {
            return false;
        }
        if (visionData != null && visionData.has("compatible")) {
            JsonArray compatibleArray = visionData.getAsJsonArray("compatible");
            for (JsonElement element : compatibleArray) {
                String value = element.getAsString();
                if (!VisionValueHandler.matchesEnchantment(value, otherEnchantment)) continue;
                return true;
            }
            return false;
        }
        if (visionData != null && visionData.has("incompatible")) {
            JsonArray incompatibleArray = visionData.getAsJsonArray("incompatible");
            for (JsonElement element : incompatibleArray) {
                String value = element.getAsString();
                if (!VisionValueHandler.matchesEnchantment(value, otherEnchantment)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchesEnchantment(String value, Enchantment enchantment) {
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (enchantmentId == null) {
            return false;
        }
        return enchantmentId.toString().equals(value);
    }

    public static boolean checkConditions(JsonObject conditionData, ItemStack itemstack) {
        return VisionValueHandler.checkConditions(conditionData, itemstack, null, null);
    }

    public static boolean checkConditions(JsonObject conditionData, Block block) {
        return VisionValueHandler.checkConditions(conditionData, null, block, null);
    }

    public static boolean checkConditions(JsonObject conditionData, Entity entity) {
        return VisionValueHandler.checkConditions(conditionData, null, null, entity);
    }

    public static boolean checkConditions(JsonObject conditionData, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity) {
        boolean conditionsMet = true;
        if (conditionData.has("conditions")) {
            JsonElement conditionsElement = conditionData.get("conditions");
            if (conditionsElement.isJsonArray()) {
                JsonElement conditionElement;
                JsonObject condition;
                JsonArray conditions = conditionsElement.getAsJsonArray();
                Iterator iterator = conditions.iterator();
                while (iterator.hasNext() && (conditionsMet = VisionValueHandler.evaluateConditions(condition = (conditionElement = (JsonElement)iterator.next()).getAsJsonObject(), itemstack, block, entity))) {
                }
            } else if (conditionsElement.isJsonObject()) {
                JsonObject condition = conditionsElement.getAsJsonObject();
                conditionsMet = VisionValueHandler.evaluateConditions(condition, itemstack, block, entity);
            } else {
                conditionsMet = false;
            }
        }
        return conditionsMet;
    }

    public static boolean checkInverted(JsonObject conditions) {
        if (conditions.has("inverted")) {
            return conditions.get("inverted").getAsBoolean();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean evaluateConditions(JsonObject conditions, @Nullable ItemStack itemstack, @Nullable Block block, @Nullable Entity entity) {
        boolean actualValue;
        String modId;
        boolean isNegated;
        if (conditions.has("mod_loaded") && isNegated == VisionValueHandler.isModLoaded(modId = modId.substring((isNegated = (modId = conditions.get("mod_loaded").getAsString()).startsWith("!")) ? 1 : 0))) {
            return false;
        }
        if (entity != null) {
            boolean isNegated2;
            String tagName;
            boolean inverted;
            CompoundTag persistentData = entity.getPersistentData();
            if (conditions.has("in_dimension")) {
                ResourceLocation dimensionLocation = entity.m_9236_().m_46472_().m_135782_();
                String dimensionId = conditions.get("in_dimension").getAsString();
                inverted = VisionValueHandler.checkInverted(conditions);
                if (inverted == dimensionLocation.equals((Object)new ResourceLocation(dimensionId))) {
                    return false;
                }
            }
            if (conditions.has("in_biome_tag")) {
                String biomeId = conditions.get("in_biome_tag").getAsString();
                Level level = entity.m_9236_();
                BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
                boolean inverted2 = VisionValueHandler.checkInverted(conditions);
                if (inverted2 == level.m_204166_(pos).m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeId)))) {
                    return false;
                }
            }
            if (conditions.has("get_x")) {
                double xVal = conditions.get("get_x").getAsDouble();
                inverted = VisionValueHandler.checkInverted(conditions);
                if (entity.m_20185_() > xVal == inverted) {
                    return false;
                }
            }
            if (conditions.has("get_y")) {
                double yVal = conditions.get("get_y").getAsDouble();
                inverted = VisionValueHandler.checkInverted(conditions);
                if (entity.m_20186_() > yVal == inverted) {
                    return false;
                }
            }
            if (conditions.has("get_z")) {
                double zVal = conditions.get("get_z").getAsDouble();
                inverted = VisionValueHandler.checkInverted(conditions);
                if (entity.m_20189_() > zVal == inverted) {
                    return false;
                }
            }
            if (conditions.has("get_integer_tag")) {
                int nbtValue;
                JsonObject getIntTag = conditions.getAsJsonObject("get_integer_tag");
                tagName = getIntTag.get("name").getAsString();
                int expectedValue = getIntTag.get("value").getAsInt();
                isNegated2 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName, 3) ? (nbtValue = persistentData.m_128451_(tagName)) == expectedValue == isNegated2 : !isNegated2) {
                    return false;
                }
            }
            if (conditions.has("get_double_tag")) {
                double nbtValue;
                JsonObject getDoubleTag = conditions.getAsJsonObject("get_double_tag");
                tagName = getDoubleTag.get("name").getAsString();
                double expectedValue = getDoubleTag.get("value").getAsDouble();
                boolean isNegated3 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName, 6) ? (nbtValue = persistentData.m_128459_(tagName)) == expectedValue == isNegated3 : !isNegated3) {
                    return false;
                }
            }
            if (conditions.has("get_string_tag")) {
                String nbtValue;
                JsonObject getStringTag = conditions.getAsJsonObject("get_string_tag");
                tagName = getStringTag.get("name").getAsString();
                String expectedValue = getStringTag.get("value").getAsString();
                isNegated2 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName, 8) ? (nbtValue = persistentData.m_128461_(tagName)).equals(expectedValue) == isNegated2 : !isNegated2) {
                    return false;
                }
            }
            if (conditions.has("get_boolean_tag")) {
                boolean nbtValue;
                JsonObject getBooleanTag = conditions.getAsJsonObject("get_boolean_tag");
                tagName = getBooleanTag.get("name").getAsString();
                boolean expectedValue = getBooleanTag.get("value").getAsBoolean();
                isNegated2 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName, 1) ? (nbtValue = persistentData.m_128471_(tagName)) == expectedValue == isNegated2 : !isNegated2) {
                    return false;
                }
            }
            if (conditions.has("has_integer_tag")) {
                String tagName2 = conditions.get("has_integer_tag").getAsString();
                boolean isNegated4 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName2, 3) == isNegated4) {
                    return false;
                }
            }
            if (conditions.has("has_double_tag")) {
                String tagName3 = conditions.get("has_double_tag").getAsString();
                boolean isNegated5 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName3, 6) == isNegated5) {
                    return false;
                }
            }
            if (conditions.has("has_string_tag")) {
                String tagName4 = conditions.get("has_string_tag").getAsString();
                boolean isNegated6 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName4, 8) == isNegated6) {
                    return false;
                }
            }
            if (conditions.has("has_boolean_tag")) {
                String tagName5 = conditions.get("has_boolean_tag").getAsString();
                boolean isNegated7 = VisionValueHandler.checkInverted(conditions);
                if (persistentData.m_128425_(tagName5, 1) == isNegated7) {
                    return false;
                }
            }
        }
        if (itemstack == null) return true;
        if (conditions.has("is_item")) {
            String itemId = conditions.get("is_item").getAsString();
            boolean inverted = VisionValueHandler.checkInverted(conditions);
            if (inverted == itemId.equals(ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_()).toString())) {
                return false;
            }
        }
        if (conditions.has("is_damageable")) {
            boolean expectedValue = conditions.get("is_damageable").getAsBoolean();
            actualValue = itemstack.m_41720_().m_41465_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_damaged")) {
            boolean expectedValue = conditions.get("is_damaged").getAsBoolean();
            actualValue = itemstack.m_41768_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_enchanted")) {
            boolean expectedValue = conditions.get("is_enchanted").getAsBoolean();
            actualValue = itemstack.m_41793_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_enchantable")) {
            boolean expectedValue = conditions.get("is_enchantable").getAsBoolean();
            actualValue = itemstack.m_41792_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_edible")) {
            boolean expectedValue = conditions.get("is_edible").getAsBoolean();
            actualValue = itemstack.m_41614_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_stackable")) {
            boolean expectedValue = conditions.get("is_stackable").getAsBoolean();
            actualValue = itemstack.m_41753_();
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_rarity")) {
            Rarity actualRarity;
            boolean rarityMatch;
            String expectedRarity = conditions.get("is_rarity").getAsString().toUpperCase();
            isNegated = VisionValueHandler.checkInverted(conditions);
            if (isNegated == (rarityMatch = (actualRarity = itemstack.m_41720_().m_41460_(itemstack)).name().equals(expectedRarity))) {
                return false;
            }
        }
        if (conditions.has("is_enchantable")) {
            boolean expectedValue = conditions.get("is_enchantable").getAsBoolean();
            actualValue = itemstack.m_41720_().m_8120_(itemstack);
            if (actualValue != expectedValue) {
                return false;
            }
        }
        if (conditions.has("is_tagged")) {
            String itemTag = conditions.get("is_tagged").getAsString();
            isNegated = VisionValueHandler.checkInverted(conditions);
            if (isNegated == itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation(itemTag)))) {
                return false;
            }
        }
        if (conditions.has("has_nbt")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_nbt").getAsString();
            isNegated = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated == (tagExists = (nbt = itemstack.m_41783_()).m_128441_(tagName)) : !isNegated) {
                return false;
            }
        }
        if (conditions.has("has_boolean_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_boolean_tag").getAsString();
            isNegated = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 1)) : !isNegated) {
                return false;
            }
        }
        if (conditions.has("get_boolean_tag")) {
            boolean nbtValue;
            CompoundTag nbt;
            JsonObject getBooleanTag = conditions.getAsJsonObject("get_boolean_tag");
            String tagName = getBooleanTag.get("name").getAsString();
            boolean expectedValue = getBooleanTag.get("value").getAsBoolean();
            boolean isNegated8 = VisionValueHandler.checkInverted(conditions);
            if (isNegated8) {
                boolean bl = expectedValue = !expectedValue;
            }
            if (itemstack.m_41782_() ? ((nbt = itemstack.m_41783_()).m_128425_(tagName, 1) ? (nbtValue = nbt.m_128471_(tagName)) != expectedValue : expectedValue) : expectedValue) {
                return false;
            }
        }
        if (conditions.has("has_int_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_int_tag").getAsString();
            boolean isNegated9 = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated9 == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 3)) : !isNegated9) {
                return false;
            }
        }
        if (conditions.has("get_int_tag")) {
            JsonObject getIntTag = conditions.getAsJsonObject("get_int_tag");
            String tagName = getIntTag.get("name").getAsString();
            String rawExpectedValue = getIntTag.get("value").getAsString();
            boolean isNegated10 = VisionValueHandler.checkInverted(conditions);
            int expectedValue = Integer.parseInt(rawExpectedValue);
            if (!itemstack.m_41782_()) return false;
            CompoundTag nbt = itemstack.m_41783_();
            if (!nbt.m_128425_(tagName, 3)) return false;
            int nbtValue = nbt.m_128451_(tagName);
            if (nbtValue == expectedValue == isNegated10) {
                return false;
            }
        }
        if (conditions.has("has_double_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_double_tag").getAsString();
            boolean isNegated11 = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated11 == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 6)) : !isNegated11) {
                return false;
            }
        }
        if (conditions.has("get_double_tag")) {
            JsonObject getDoubleTag = conditions.getAsJsonObject("get_double_tag");
            String tagName = getDoubleTag.get("name").getAsString();
            String rawExpectedValue = getDoubleTag.get("value").getAsString();
            boolean isNegated12 = VisionValueHandler.checkInverted(conditions);
            double expectedValue = Double.parseDouble(rawExpectedValue);
            if (!itemstack.m_41782_()) return false;
            CompoundTag nbt = itemstack.m_41783_();
            if (!nbt.m_128425_(tagName, 6)) return false;
            double nbtValue = nbt.m_128459_(tagName);
            if (nbtValue == expectedValue == isNegated12) {
                return false;
            }
        }
        if (conditions.has("has_long_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_long_tag").getAsString();
            boolean isNegated13 = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated13 == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 4)) : !isNegated13) {
                return false;
            }
        }
        if (conditions.has("get_long_tag")) {
            JsonObject getLongTag = conditions.getAsJsonObject("get_long_tag");
            String tagName = getLongTag.get("name").getAsString();
            String rawExpectedValue = getLongTag.get("value").getAsString();
            boolean isNegated14 = VisionValueHandler.checkInverted(conditions);
            long expectedValue = Long.parseLong(rawExpectedValue);
            if (!itemstack.m_41782_()) return false;
            CompoundTag nbt = itemstack.m_41783_();
            if (!nbt.m_128425_(tagName, 4)) return false;
            long nbtValue = nbt.m_128454_(tagName);
            if (nbtValue == expectedValue == isNegated14) {
                return false;
            }
        }
        if (conditions.has("has_short_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_short_tag").getAsString();
            boolean isNegated15 = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated15 == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 2)) : !isNegated15) {
                return false;
            }
        }
        if (conditions.has("get_short_tag")) {
            JsonObject getShortTag = conditions.getAsJsonObject("get_short_tag");
            String tagName = getShortTag.get("name").getAsString();
            String rawExpectedValue = getShortTag.get("value").getAsString();
            boolean isNegated16 = VisionValueHandler.checkInverted(conditions);
            short expectedValue = Short.parseShort(rawExpectedValue);
            if (!itemstack.m_41782_()) return false;
            CompoundTag nbt = itemstack.m_41783_();
            if (!nbt.m_128425_(tagName, 2)) return false;
            short nbtValue = nbt.m_128448_(tagName);
            if (nbtValue == expectedValue == isNegated16) {
                return false;
            }
        }
        if (conditions.has("has_string_tag")) {
            CompoundTag nbt;
            boolean tagExists;
            String tagName = conditions.get("has_string_tag").getAsString();
            boolean isNegated17 = VisionValueHandler.checkInverted(conditions);
            if (itemstack.m_41782_() ? isNegated17 == (tagExists = (nbt = itemstack.m_41783_()).m_128425_(tagName, 8)) : !isNegated17) {
                return false;
            }
        }
        if (!conditions.has("get_string_tag")) return true;
        JsonObject getStringTag = conditions.getAsJsonObject("get_string_tag");
        String tagName = getStringTag.get("name").getAsString();
        String rawExpectedValue = getStringTag.get("value").getAsString();
        boolean isNegated18 = VisionValueHandler.checkInverted(conditions);
        String expectedValue = rawExpectedValue;
        if (!itemstack.m_41782_()) return false;
        CompoundTag nbt = itemstack.m_41783_();
        if (!nbt.m_128425_(tagName, 8)) return false;
        String nbtValue = nbt.m_128461_(tagName);
        if (nbtValue.equals(expectedValue) == isNegated18) return false;
        return true;
    }

    public static ItemStack setNBTs(JsonObject itemData, ItemStack itemstack) {
        CompoundTag tag = itemstack.m_41784_();
        if (itemData != null && itemData.has("nbt")) {
            JsonArray tagArray = itemData.getAsJsonArray("nbt");
            for (JsonElement element : tagArray) {
                JsonObject tagData = element.getAsJsonObject();
                if (!VisionValueHandler.checkConditions(tagData, itemstack) || !tagData.has("value") || !tagData.has("type") || !tagData.has("name")) continue;
                String type = tagData.get("type").getAsString();
                String name = tagData.get("name").getAsString();
                JsonElement valueElement = tagData.get("value");
                if (tag.m_128441_(name)) continue;
                switch (type) {
                    case "boolean": 
                    case "bool": {
                        boolean booleanValue = valueElement.getAsBoolean();
                        tag.m_128379_(name, booleanValue);
                        break;
                    }
                    case "int": 
                    case "integer": {
                        int intValue = valueElement.getAsInt();
                        tag.m_128405_(name, intValue);
                        break;
                    }
                    case "decimal": 
                    case "double": {
                        double doubleValue = valueElement.getAsDouble();
                        tag.m_128347_(name, doubleValue);
                        break;
                    }
                    case "string": {
                        String stringValue = valueElement.getAsString();
                        tag.m_128359_(name, stringValue);
                        break;
                    }
                }
            }
        }
        itemstack.m_41751_(tag);
        return itemstack;
    }

    public static List<String> getStringListFromJsonArray(JsonArray jsonArray) {
        ArrayList<String> values = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            JsonObject jsonObject;
            if (!element.isJsonObject() || !(jsonObject = element.getAsJsonObject()).has("value") || !jsonObject.get("value").isJsonPrimitive()) continue;
            values.add(jsonObject.get("value").getAsString());
        }
        return values;
    }

    public static List<String> getListOfStrings(JsonObject itemData, String checkFor, @Nullable Entity entity) {
        return VisionValueHandler.getListOfStrings(itemData, checkFor, "value", entity);
    }

    public static List<String> getListOfStrings(JsonObject itemData, String checkFor, String valueString, @Nullable Entity entity) {
        JsonArray jsonArray = itemData.getAsJsonArray(checkFor);
        ArrayList<String> validValues = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (!VisionValueHandler.checkConditions(jsonObject, entity) || !jsonObject.has(valueString)) continue;
            int weight = 1;
            if (jsonObject.has("weight")) {
                weight = jsonObject.get("weight").getAsInt();
            }
            for (int i = 0; i < weight; ++i) {
                validValues.add(jsonObject.get(valueString).getAsString());
            }
        }
        return validValues;
    }

    public static String getRarity(JsonObject itemData, ItemStack itemstack, String defaultRarity) {
        String rarity = defaultRarity;
        JsonArray rarityArray = itemData.getAsJsonArray("rarity");
        for (JsonElement element : rarityArray) {
            JsonObject rarityData = element.getAsJsonObject();
            if (!VisionValueHandler.checkConditions(rarityData, itemstack) || !rarityData.has("value")) continue;
            rarity = rarityData.get("value").getAsString();
            break;
        }
        return rarity;
    }

    public static List<String> getTooltips(JsonObject jsonData, @Nullable ItemStack itemstack, Boolean start) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (jsonData.has("tooltip")) {
            JsonArray tooltipArray = jsonData.getAsJsonArray("tooltip");
            for (JsonElement element : tooltipArray) {
                JsonObject tooltipData = element.getAsJsonObject();
                if (!VisionValueHandler.checkConditions(tooltipData, itemstack) || !tooltipData.has("value")) continue;
                String tooltip = tooltipData.get("value").getAsString();
                if (tooltipData.has("position") && (!tooltipData.get("position").getAsString().equals("start") || !start.booleanValue()) && (!tooltipData.get("position").getAsString().equals("end") || start.booleanValue())) continue;
                tooltips.add(tooltip);
            }
        }
        return tooltips;
    }
}

