/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.util;

import com.google.gson.JsonObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.lixir.vminus.network.VminusModVariables;

public enum VisionType {
    ITEM(0, "item_visions", "items"),
    BLOCK(1, "block_visions", "blocks"),
    ENTITY(2, "entity_visions", "entities"),
    EFFECT(3, "effect_visions", "effects"),
    ENCHANTMENT(4, "enchantment_visions", "enchantments");

    private final ConcurrentHashMap<String, Integer> visionKey = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<JsonObject> visionCache = new CopyOnWriteArrayList();
    private final byte id;
    private final String directory;
    private final String listType;

    private VisionType(byte id, String directory, String listType) {
        this.id = id;
        this.directory = directory;
        this.listType = listType;
    }

    @Nullable
    public JsonObject getMainVision() {
        switch (this.id) {
            case 0: {
                return VminusModVariables.main_item_vision;
            }
            case 1: {
                return VminusModVariables.main_block_vision;
            }
            case 2: {
                return VminusModVariables.main_entity_vision;
            }
            case 3: {
                return VminusModVariables.main_effect_vision;
            }
            case 4: {
                return VminusModVariables.main_enchantment_vision;
            }
        }
        return null;
    }

    public ConcurrentHashMap<String, Integer> getVisionKey() {
        return this.visionKey;
    }

    public CopyOnWriteArrayList<JsonObject> getVisionCache() {
        return this.visionCache;
    }

    public byte getId() {
        return this.id;
    }

    public String getDirectoryName() {
        return this.directory;
    }

    public String getListType() {
        return this.listType;
    }

    public static VisionType getFromDirectory(String folderName) {
        return switch (folderName) {
            case "item_visions" -> ITEM;
            case "block_visions" -> BLOCK;
            case "entity_visions" -> ENTITY;
            case "effect_visions" -> EFFECT;
            case "enchantment_visions" -> ENCHANTMENT;
            default -> throw new IllegalStateException("Unexpected Folder Name: " + folderName);
        };
    }

    public void setMainVision(JsonObject jsonObject) {
        switch (this.id) {
            case 0: {
                VminusModVariables.main_item_vision = jsonObject;
                break;
            }
            case 1: {
                VminusModVariables.main_block_vision = jsonObject;
                break;
            }
            case 2: {
                VminusModVariables.main_entity_vision = jsonObject;
                break;
            }
            case 3: {
                VminusModVariables.main_effect_vision = jsonObject;
                break;
            }
            case 4: {
                VminusModVariables.main_enchantment_vision = jsonObject;
            }
        }
    }

    public void clearMainVision() {
        switch (this.id) {
            case 0: {
                VminusModVariables.main_item_vision = new JsonObject();
                break;
            }
            case 1: {
                VminusModVariables.main_block_vision = new JsonObject();
                break;
            }
            case 2: {
                VminusModVariables.main_entity_vision = new JsonObject();
                break;
            }
            case 3: {
                VminusModVariables.main_effect_vision = new JsonObject();
                break;
            }
            case 4: {
                VminusModVariables.main_enchantment_vision = new JsonObject();
            }
        }
    }
}

