/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.util;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lixir.vminus.VMinusConfig;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class VisionPropertyHandler {
    public static boolean isBanned(@Nullable ItemStack itemStack, @Nullable JsonObject visionData) {
        if (itemStack == null) {
            return false;
        }
        if (VisionPropertyHandler.isItemConfigBanned(itemStack)) {
            return true;
        }
        return VisionPropertyHandler.getBoolean(itemStack, "banned", visionData);
    }

    public static boolean isBanned(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (VisionPropertyHandler.isItemConfigBanned(itemStack)) {
            return true;
        }
        return VisionPropertyHandler.getBoolean(itemStack, "banned", null);
    }

    public static boolean isItemConfigBanned(ItemStack itemStack) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (resourceLocation == null) {
            return false;
        }
        return ((List)VMinusConfig.BANNED_ITEMS.get()).contains(resourceLocation.toString());
    }

    public static boolean isItemConfigHidden(ItemStack itemStack) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (resourceLocation == null) {
            return false;
        }
        return ((List)VMinusConfig.HIDDEN_ITEMS.get()).contains(resourceLocation.toString());
    }

    @Nullable
    public static ItemStack getReplacement(@Nullable ItemStack itemStack) {
        return VisionPropertyHandler.getReplacement(itemStack, null, null);
    }

    @Nullable
    public static ItemStack getReplacement(@Nullable ItemStack itemStack, String specificReplace) {
        return VisionPropertyHandler.getReplacement(itemStack, null, specificReplace);
    }

    @Nullable
    public static ItemStack getDropReplacement(@Nullable ItemStack itemStack, @Nullable JsonObject visionData) {
        return VisionPropertyHandler.getReplacement(itemStack, visionData, "replace_drop");
    }

    @Nullable
    public static ItemStack getIngredientReplacement(@Nullable ItemStack itemStack, @Nullable JsonObject visionData) {
        return VisionPropertyHandler.getReplacement(itemStack, visionData, "replace_recipe_ingredient");
    }

    @Nullable
    public static ItemStack getReplacement(@Nullable ItemStack itemStack, @Nullable JsonObject visionData, @Nullable String specificReplace) {
        if (visionData == null) {
            visionData = VisionHandler.getVisionData(itemStack);
        }
        if (visionData == null) {
            return null;
        }
        String replaceID = VisionValueHandler.getFirstValidString(visionData, "replace", itemStack);
        if ((replaceID == null || replaceID.isEmpty()) && specificReplace != null && !specificReplace.isEmpty() && visionData.has(specificReplace)) {
            replaceID = VisionValueHandler.getFirstValidString(visionData, specificReplace, itemStack);
        }
        return replaceID != null && !replaceID.isEmpty() ? new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(replaceID)))) : null;
    }

    public static boolean matchesIngredient(ItemStack targetStack, Ingredient.Value[] values) {
        for (Ingredient.Value value : values) {
            for (ItemStack stack : value.m_6223_()) {
                JsonObject visionData;
                ItemStack replacementStack = VisionPropertyHandler.getIngredientReplacement(stack, visionData = VisionHandler.getVisionData(stack));
                if (replacementStack != null && replacementStack.m_150930_(targetStack.m_41720_())) {
                    return true;
                }
                if (VisionPropertyHandler.isBanned(stack, visionData) || !stack.m_150930_(targetStack.m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ItemStack getRecipeOutputReplacement(@Nullable ItemStack itemStack) {
        JsonObject visionData = VisionHandler.getVisionData(itemStack);
        if (visionData != null) {
            boolean isBanned = VisionPropertyHandler.isBanned(itemStack, visionData);
            if (isBanned) {
                return new ItemStack((ItemLike)Items.f_41852_);
            }
            ItemStack replacementStack = VisionPropertyHandler.getReplacement(itemStack, visionData, "replace_recipe_output");
            if (replacementStack != null && !replacementStack.m_41619_()) {
                return replacementStack;
            }
        }
        return itemStack;
    }

    public static boolean getBoolean(@Nullable ItemStack itemstack, String property) {
        return VisionPropertyHandler.getBoolean(itemstack, property, null);
    }

    public static boolean getBoolean(@Nullable ItemStack itemStack, String property, @Nullable JsonObject visionData) {
        if (visionData == null) {
            visionData = VisionHandler.getVisionData(itemStack);
        }
        return visionData != null && visionData.has(property) && VisionValueHandler.isBooleanMet(visionData, property, itemStack);
    }

    public static boolean getBoolean(@Nullable Block block, String property) {
        return VisionPropertyHandler.getBoolean(block, property, null);
    }

    public static boolean getBoolean(@Nullable Block block, String property, @Nullable JsonObject visionData) {
        if (visionData == null) {
            visionData = VisionHandler.getVisionData(block);
        }
        return visionData != null && visionData.has(property) && VisionValueHandler.isBooleanMet(visionData, property, block);
    }
}

