/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.resources.VisionResourceHandler;
import net.lixir.vminus.visions.util.VisionType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class VisionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String directory;
    private final VisionType visionType;
    private final ICondition.IContext context;
    private static final int PATH_SUFFIX_LENGTH = ".json".length();

    public VisionManager(VisionType visionType, ICondition.IContext context) {
        super(GSON, "");
        this.directory = visionType.getDirectoryName();
        this.visionType = visionType;
        this.context = context;
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214159_(this.directory, p_215600_ -> p_215600_.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            String s = resourcelocation.m_135815_();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.m_135827_(), s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                JsonElement jsonelement1 = map.put(resourcelocation1, jsonelement);
                if (jsonelement1 == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonParseException) {
                VMinusMod.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonParseException);
            }
        }
        return map;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        File[] jsonFiles;
        JsonObject mainJsonObject = new JsonObject();
        for (Map.Entry<ResourceLocation, JsonElement> jsonFile : resourceLocationJsonElementMap.entrySet()) {
            try {
                JsonObject jsonObject = VisionResourceHandler.processJsonObject(this.directory, jsonFile.getValue());
                for (String key : jsonObject.keySet()) {
                    JsonElement value = jsonObject.get(key);
                    if (mainJsonObject.has(key)) {
                        JsonObject existingObject = mainJsonObject.getAsJsonObject(key);
                        JsonObject newObject = value.getAsJsonObject();
                        VisionResourceHandler.mergeJsonObjects(existingObject, newObject, 0);
                        continue;
                    }
                    mainJsonObject.add(key, value);
                }
            }
            catch (Exception e) {
                VMinusMod.LOGGER.error("Error processing JSON file: {}", (Object)jsonFile.getKey(), (Object)e);
            }
        }
        File configDir = new File("config/vminus/" + this.directory);
        if (!configDir.exists() && !configDir.mkdirs()) {
            VMinusMod.LOGGER.error("Failed to create directory: {}", (Object)configDir.getPath());
        }
        if (configDir.exists() && configDir.isDirectory() && (jsonFiles = configDir.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : jsonFiles) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject configJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    try {
                        JsonObject jsonObject = VisionResourceHandler.processJsonObject(this.directory, (JsonElement)configJson);
                        for (String key : jsonObject.keySet()) {
                            JsonElement value = jsonObject.get(key);
                            if (mainJsonObject.has(key)) {
                                JsonObject existingObject = mainJsonObject.getAsJsonObject(key);
                                JsonObject newObject = value.getAsJsonObject();
                                VisionResourceHandler.mergeJsonObjects(existingObject, newObject, 0);
                                continue;
                            }
                            mainJsonObject.add(key, value);
                        }
                    }
                    catch (Exception e) {
                        VMinusMod.LOGGER.error("Error processing JSON file: {}", (Object)file.getName(), (Object)e);
                    }
                }
                catch (IOException e) {
                    VMinusMod.LOGGER.error("Error reading config: {}", (Object)file.getName(), (Object)e);
                }
            }
        }
        this.visionType.getVisionKey().clear();
        this.visionType.getVisionCache().clear();
        this.visionType.setMainVision(mainJsonObject);
        VisionHandler.processAllVisionDataForType(this.visionType, this.context);
        this.visionType.clearMainVision();
    }

    @NotNull
    protected ResourceLocation getPreparedPath(ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), this.directory + "/" + rl.m_135815_() + ".json");
    }
}

