/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.lixir.vminus.visions.util.VisionType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class VisionHandler {
    public static final int EMPTY_KEY = -1;

    private static JsonObject scanVisionJsonKey(JsonObject mainVision, String key, String id, JsonObject mergedData, @Nullable Object object, @Nullable ICondition.IContext context) {
        String originalKey = key;
        key = key.trim();
        List<String> parts = VisionHandler.processKeyString(key);
        boolean invalidMatch = false;
        boolean validMatchFound = false;
        for (String matchKey : parts) {
            boolean inverted = matchKey.startsWith("!");
            if (inverted) {
                matchKey = matchKey.substring(1);
            }
            boolean found = false;
            boolean isTag = matchKey.startsWith("#");
            if (isTag) {
                matchKey = matchKey.substring(1);
            }
            if (matchKey.equals(id) || matchKey.equals("global")) {
                found = true;
            } else if (isTag) {
                if (object instanceof Item) {
                    Item item = (Item)object;
                    found = VisionHandler.isItemTagged(item, new ResourceLocation(matchKey), context);
                } else if (object instanceof Block) {
                    Block block = (Block)object;
                    found = VisionHandler.isBlockTagged(block, new ResourceLocation(matchKey), context);
                } else if (object instanceof EntityType) {
                    EntityType entityType = (EntityType)object;
                    found = VisionHandler.isEntityTagged(entityType, new ResourceLocation(matchKey), context);
                }
            }
            if (inverted) {
                boolean bl = found = !found;
            }
            if (!inverted && found) {
                validMatchFound = true;
                continue;
            }
            if (!inverted || found) continue;
            invalidMatch = true;
            break;
        }
        if (invalidMatch || !validMatchFound) {
            return mergedData;
        }
        JsonObject matchedData = mainVision.getAsJsonObject(originalKey);
        if (matchedData != null) {
            return VisionHandler.mergeJsonObjects(mergedData, matchedData);
        }
        return mergedData;
    }

    private static List<String> processKeyString(String key) {
        if ((key = key.trim()).endsWith(",")) {
            key = key.substring(0, key.length() - 1);
        }
        return Arrays.stream(key.split(",")).map(String::trim).toList();
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable ItemStack itemstack) {
        return VisionHandler.getVisionData(itemstack, (Boolean)false, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable ItemStack itemstack, int key) {
        return VisionHandler.getVisionData(itemstack, (Boolean)false, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable ItemStack itemstack, @Nullable Boolean debug) {
        return VisionHandler.getVisionData(itemstack, debug, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable ItemStack itemstack, @Nullable Boolean debug, int key) {
        if (itemstack == null) {
            return null;
        }
        String id = VisionHandler.attemptGetObjectId(itemstack);
        if (id == null || id.isEmpty()) {
            return null;
        }
        VisionType visionType = VisionHandler.getVisionType(itemstack);
        if (visionType == null) {
            return null;
        }
        return VisionHandler.processVisionData(visionType, id, itemstack, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Block block, int key) {
        return VisionHandler.getVisionData(block, (Boolean)false, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Block block) {
        return VisionHandler.getVisionData(block, (Boolean)false, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Block block, @Nullable Boolean debug) {
        return VisionHandler.getVisionData(block, debug, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Block block, @Nullable Boolean debug, int key) {
        String id = VisionHandler.attemptGetObjectId(block);
        if (id == null || id.isEmpty()) {
            return null;
        }
        VisionType visionType = VisionHandler.getVisionType(block);
        if (visionType == null) {
            return null;
        }
        return VisionHandler.processVisionData(visionType, id, block, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable EntityType<?> entityType) {
        return VisionHandler.getVisionData(entityType, (Boolean)false, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable EntityType<?> entityType, @Nullable Boolean debug) {
        return VisionHandler.getVisionData(entityType, debug, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable EntityType<?> entityType, @Nullable Boolean debug, int key) {
        String id = VisionHandler.attemptGetObjectId(entityType);
        if (id == null || id.isEmpty()) {
            return null;
        }
        VisionType visionType = VisionHandler.getVisionType(entityType);
        if (visionType == null) {
            return null;
        }
        return VisionHandler.processVisionData(visionType, id, entityType, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable MobEffect mobEffect) {
        return VisionHandler.getVisionData(mobEffect, (Boolean)false, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable MobEffect mobEffect, @Nullable Boolean debug) {
        return VisionHandler.getVisionData(mobEffect, debug, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable MobEffect mobEffect, @Nullable Boolean debug, int key) {
        String id = VisionHandler.attemptGetObjectId(mobEffect);
        if (id == null || id.isEmpty()) {
            return null;
        }
        VisionType visionType = VisionHandler.getVisionType(mobEffect);
        if (visionType == null) {
            return null;
        }
        return VisionHandler.processVisionData(visionType, id, mobEffect, key);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Enchantment enchantment) {
        return VisionHandler.getVisionData(enchantment, (Boolean)false, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Enchantment enchantment, @Nullable Boolean debug) {
        return VisionHandler.getVisionData(enchantment, debug, -1);
    }

    @Nullable
    public static JsonObject getVisionData(@Nullable Enchantment enchantment, @Nullable Boolean debug, int key) {
        String id = VisionHandler.attemptGetObjectId(enchantment);
        if (id == null || id.isEmpty()) {
            return null;
        }
        VisionType visionType = VisionHandler.getVisionType(enchantment);
        if (visionType == null) {
            return null;
        }
        return VisionHandler.processVisionData(visionType, id, enchantment, key);
    }

    @Nullable
    private static String attemptGetObjectId(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41782_() && itemStack.m_41784_().m_128441_("vision")) {
            return itemStack.m_41784_().m_128461_("vision");
        }
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString();
    }

    @Nullable
    private static String attemptGetObjectId(@Nullable Block block) {
        if (block == null) {
            return null;
        }
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString();
    }

    @Nullable
    private static String attemptGetObjectId(@Nullable EntityType<?> entityType) {
        if (entityType == null) {
            return null;
        }
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).toString();
    }

    @Nullable
    private static String attemptGetObjectId(@Nullable MobEffect mobEffect) {
        if (mobEffect == null) {
            return null;
        }
        return Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect)).toString();
    }

    @Nullable
    private static String attemptGetObjectId(@Nullable Enchantment enchantment) {
        if (enchantment == null) {
            return null;
        }
        return Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).toString();
    }

    @Nullable
    private static VisionType getVisionType(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return VisionType.ITEM;
    }

    @Nullable
    private static VisionType getVisionType(@Nullable Block block) {
        if (block == null) {
            return null;
        }
        return VisionType.BLOCK;
    }

    @Nullable
    private static VisionType getVisionType(@Nullable EntityType<?> entityType) {
        if (entityType == null) {
            return null;
        }
        return VisionType.ENTITY;
    }

    @Nullable
    private static VisionType getVisionType(@Nullable MobEffect mobEffect) {
        if (mobEffect == null) {
            return null;
        }
        return VisionType.EFFECT;
    }

    @Nullable
    private static VisionType getVisionType(@Nullable Enchantment enchantment) {
        if (enchantment == null) {
            return null;
        }
        return VisionType.ENCHANTMENT;
    }

    public static void processAllVisionDataForType(VisionType visionType, @Nullable ICondition.IContext context) {
        switch (visionType) {
            case ITEM: {
                for (Item item : ForgeRegistries.ITEMS.getValues()) {
                    VisionHandler.processVisionData(visionType, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString(), item, -1, context);
                }
                break;
            }
            case BLOCK: {
                for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                    VisionHandler.processVisionData(visionType, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString(), block, -1, context);
                }
                break;
            }
            case ENTITY: {
                for (EntityType entity : ForgeRegistries.ENTITY_TYPES.getValues()) {
                    VisionHandler.processVisionData(visionType, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity)).toString(), entity, -1, context);
                }
                break;
            }
            case EFFECT: {
                for (MobEffect effect : ForgeRegistries.MOB_EFFECTS.getValues()) {
                    VisionHandler.processVisionData(visionType, Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)).toString(), effect, -1, context);
                }
                break;
            }
            case ENCHANTMENT: {
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
                    VisionHandler.processVisionData(visionType, Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).toString(), enchantment, -1, context);
                }
                break;
            }
        }
    }

    public static JsonObject processVisionData(VisionType visionType, String id, @Nullable Object object, int key) {
        return VisionHandler.processVisionData(visionType, id, object, key, null);
    }

    public static JsonObject processVisionData(VisionType visionType, String id, @Nullable Object object, int key, @Nullable ICondition.IContext context) {
        JsonObject objectFromKey = VisionHandler.getCacheByKey(key, visionType);
        if (objectFromKey != null) {
            return objectFromKey;
        }
        ConcurrentHashMap<String, Integer> visionKeyMap = visionType.getVisionKey();
        CopyOnWriteArrayList<JsonObject> visionCache = visionType.getVisionCache();
        JsonObject mainVision = visionType.getMainVision();
        if (mainVision == null) {
            return null;
        }
        int index = visionKeyMap.getOrDefault(id, -1);
        JsonObject cachedJsonObject = VisionHandler.getCacheByKey(index, visionType);
        if (cachedJsonObject != null) {
            return cachedJsonObject;
        }
        JsonObject jsonObject = new JsonObject();
        for (String mainVisionKey : mainVision.keySet()) {
            jsonObject = VisionHandler.scanVisionJsonKey(mainVision, mainVisionKey, id, jsonObject, object, context);
        }
        index = VisionHandler.getKeyFromMatchingCache(visionCache, jsonObject);
        if (index != -1) {
            ((AbstractMap)visionKeyMap).put(id, index);
            return visionCache.get(index);
        }
        VisionHandler.cacheVisionData(jsonObject, visionKeyMap, visionCache, id);
        return jsonObject;
    }

    public static int getCacheKey(@Nullable ItemStack itemStack) {
        return VisionHandler.getCacheKey(VisionHandler.getVisionType(itemStack), VisionHandler.attemptGetObjectId(itemStack));
    }

    public static int getCacheKey(@Nullable Block block) {
        return VisionHandler.getCacheKey(VisionHandler.getVisionType(block), VisionHandler.attemptGetObjectId(block));
    }

    public static int getCacheKey(VisionType visionType, String id) {
        if (visionType == null || id == null) {
            return -1;
        }
        ConcurrentHashMap<String, Integer> visionKeyMap = visionType.getVisionKey();
        return visionKeyMap.getOrDefault(id, -1);
    }

    @Nullable
    public static JsonObject getCacheByKey(int index, VisionType visionType) {
        if (index == -1) {
            return null;
        }
        CopyOnWriteArrayList<JsonObject> visionCache = visionType.getVisionCache();
        ConcurrentHashMap<String, Integer> visionKey = visionType.getVisionKey();
        if (visionCache.isEmpty()) {
            return null;
        }
        if (visionKey.isEmpty()) {
            return null;
        }
        if (visionKey.containsKey(index)) {
            return null;
        }
        return visionCache.get(index);
    }

    public static int getKeyFromMatchingCache(CopyOnWriteArrayList<JsonObject> visionCache, JsonObject checkingObject) {
        for (int i = 0; i < visionCache.size(); ++i) {
            if (!visionCache.get(i).equals((Object)checkingObject)) continue;
            return i;
        }
        return -1;
    }

    private static void cacheVisionData(JsonObject jsonObject, AbstractMap<String, Integer> visionKeyMap, CopyOnWriteArrayList<JsonObject> visionCache, String id) {
        int newIndex = visionCache.size();
        visionKeyMap.put(id, newIndex);
        if (jsonObject == null) {
            jsonObject = new JsonObject();
        }
        visionCache.add(jsonObject);
    }

    private static boolean isItemTagged(Item item, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        if (context == null) {
            return false;
        }
        TagKey itemTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)matchKey);
        Collection tags = context.getTag(itemTagKey);
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemKey == null) {
            return false;
        }
        return tags.stream().anyMatch(holder -> {
            ResourceLocation holderKey = ForgeRegistries.ITEMS.getKey((Object)((Item)holder.m_203334_()));
            return Objects.equals(holderKey, itemKey);
        });
    }

    private static boolean isBlockTagged(Block block, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        if (context == null) {
            return false;
        }
        TagKey blockTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)matchKey);
        Collection tags = context.getTag(blockTagKey);
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        ResourceLocation blockKey = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockKey == null) {
            return false;
        }
        return tags.stream().anyMatch(holder -> {
            ResourceLocation holderKey = ForgeRegistries.BLOCKS.getKey((Object)((Block)holder.m_203334_()));
            return Objects.equals(holderKey, blockKey);
        });
    }

    private static boolean isEntityTagged(EntityType<?> entityType, ResourceLocation matchKey, @Nullable ICondition.IContext context) {
        if (context == null) {
            return false;
        }
        TagKey entityTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)matchKey);
        Collection tags = context.getTag(entityTagKey);
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        ResourceLocation entityKey = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (entityKey == null) {
            return false;
        }
        return tags.stream().anyMatch(holder -> {
            ResourceLocation holderKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)holder.m_203334_()));
            return Objects.equals(holderKey, entityKey);
        });
    }

    private static JsonObject mergeJsonObjects(@Nullable JsonObject target, JsonObject source) {
        if (target == null) {
            target = new JsonObject();
        }
        for (String key : source.keySet()) {
            JsonElement sourceElement = source.get(key);
            if (sourceElement.isJsonArray()) {
                JsonArray sourceArray = sourceElement.getAsJsonArray();
                JsonArray targetArray = target.has(key) ? target.getAsJsonArray(key) : new JsonArray();
                JsonArray mergedArray = VisionHandler.mergeJsonArrays(targetArray, sourceArray);
                target.add(key, (JsonElement)mergedArray);
                continue;
            }
            target.add(key, sourceElement);
        }
        return target;
    }

    private static JsonArray mergeJsonArrays(JsonArray targetArray, JsonArray sourceArray) {
        JsonArray mergedArray = new JsonArray();
        for (JsonElement element : targetArray) {
            mergedArray.add(element);
        }
        for (JsonElement element : sourceArray) {
            mergedArray.add(element);
        }
        return mergedArray;
    }
}

