/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.lixir.vminus.block.entity.ModHangingSignBlockEntity;
import net.lixir.vminus.block.entity.ModSignBlockEntity;
import net.lixir.vminus.registry.util.BlockSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class VMinusBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"vminus");
    public static final RegistryObject<BlockEntityType<ModSignBlockEntity>> MOD_SIGN = BLOCK_ENTITIES.register("mod_sign", () -> {
        List<Block> signBlocks = BlockSet.BLOCK_SETS.stream().filter(set -> set.hasSign()).flatMap(set -> Stream.of(set.getStandingSignBlock(), set.getWallSignBlock())).filter(Objects::nonNull).toList();
        return BlockEntityType.Builder.m_155273_(ModSignBlockEntity::new, (Block[])signBlocks.toArray(new Block[0])).m_58966_(null);
    });
    public static final RegistryObject<BlockEntityType<ModHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITIES.register("hanging_mod_sign", () -> {
        List<Block> hangingSignBlocks = BlockSet.BLOCK_SETS.stream().flatMap(set -> Stream.of(set.getHangingSignBlock(), set.getWallHangingSignBlock())).filter(Objects::nonNull).toList();
        return BlockEntityType.Builder.m_155273_(ModHangingSignBlockEntity::new, (Block[])hangingSignBlocks.toArray(new Block[0])).m_58966_(null);
    });

    private static RegistryObject<BlockEntityType<?>> register(String registryname, RegistryObject<Block> block, BlockEntityType.BlockEntitySupplier<?> supplier) {
        return BLOCK_ENTITIES.register(registryname, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }
}

