/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.world;

import net.lixir.vminus.visions.util.VisionPropertyHandler;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin {
    @Inject(method={"addResource(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddResource(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (VisionPropertyHandler.isBanned(stack)) {
            cir.cancel();
        }
    }

    @Inject(method={"addResource(ILnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddResource(int slot, ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (VisionPropertyHandler.isBanned(stack)) {
            cir.cancel();
        }
    }

    @Inject(method={"getSlotWithRemainingSpace(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetSlotWithRemainingSpace(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (VisionPropertyHandler.isBanned(stack)) {
            cir.cancel();
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAdd(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (VisionPropertyHandler.isBanned(stack)) {
            cir.cancel();
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAdd(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (VisionPropertyHandler.isBanned(stack)) {
            cir.cancel();
        }
    }

    @Inject(method={"placeItemBackInInventory(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaceItemBackInInventory(ItemStack stack, CallbackInfo ci) {
        if (VisionPropertyHandler.isBanned(stack)) {
            ci.cancel();
        }
    }

    @Inject(method={"placeItemBackInInventory(Lnet/minecraft/world/item/ItemStack;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaceItemBackInInventory(ItemStack stack, boolean drop, CallbackInfo ci) {
        if (VisionPropertyHandler.isBanned(stack)) {
            ci.cancel();
        }
    }
}

