/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.level;

import com.google.gson.JsonObject;
import net.lixir.vminus.helpers.DirectionHelper;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin {
    @Unique
    private final Level vminus$level = (Level)this;

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void setBlock(BlockPos pos, BlockState state, int i, CallbackInfoReturnable<Boolean> cir) {
        Block block = state.m_60734_();
        JsonObject visionData = VisionHandler.getVisionData(block);
        if (visionData != null) {
            BlockState updatedState;
            Direction direction;
            String directionString;
            boolean banned;
            if (visionData.has("replace")) {
                ResourceLocation resourceLocation;
                Block replacingBlock;
                String replaceString = VisionValueHandler.getFirstValidString(visionData, "replace", block);
                if (replaceString != null && (replacingBlock = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation = new ResourceLocation(replaceString))) != null) {
                    LevelAccessor world = (LevelAccessor)this;
                    cir.setReturnValue((Object)this.vminus$level.m_7731_(pos, replacingBlock.m_49966_(), i));
                    world.m_186460_(pos, replacingBlock, 1);
                }
            } else if (visionData.has("banned") && (banned = VisionValueHandler.isBooleanMet(visionData, "banned", block))) {
                cir.cancel();
                return;
            }
            if (visionData.has("constant_direction") && (directionString = VisionValueHandler.getFirstValidString(visionData, "constant_direction", block)) != null && (direction = DirectionHelper.getDirectionFromString(directionString)) != null && (updatedState = DirectionHelper.applyDirectionToBlockState(state, direction)) != null && !state.equals(updatedState)) {
                cir.setReturnValue((Object)this.vminus$level.m_7731_(pos, updatedState, i));
            }
        }
    }
}

