/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.level;

import com.google.gson.JsonObject;
import net.lixir.vminus.helpers.DirectionHelper;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkSection.class})
public abstract class LevelChunkSectionMixin {
    @Unique
    private final LevelChunkSection vminus$levelChunkSection = (LevelChunkSection)this;

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void setBlockState(int x, int y, int z, BlockState state, boolean flag, CallbackInfoReturnable<BlockState> cir) {
        Block block = state.m_60734_();
        JsonObject visionData = VisionHandler.getVisionData(block);
        if (visionData != null) {
            boolean banned;
            if (visionData.has("replace")) {
                String replaceString = VisionValueHandler.getFirstValidString(visionData, "replace", block);
                if (replaceString == null) {
                    return;
                }
                ResourceLocation replaceResourceLocation = new ResourceLocation(replaceString);
                Block replacingBlock = (Block)ForgeRegistries.BLOCKS.getValue(replaceResourceLocation);
                if (replacingBlock != null) {
                    cir.setReturnValue((Object)this.vminus$levelChunkSection.m_62991_(x, y, z, replacingBlock.m_49966_(), flag));
                }
            } else if (visionData.has("banned") && (banned = VisionValueHandler.isBooleanMet(visionData, "banned", block))) {
                cir.cancel();
                return;
            }
            if (visionData.has("constant_direction")) {
                BlockState updatedState;
                String directionString = VisionValueHandler.getFirstValidString(visionData, "constant_direction", block);
                if (directionString == null) {
                    return;
                }
                Direction direction = DirectionHelper.getDirectionFromString(directionString);
                if (direction != null && (updatedState = DirectionHelper.applyDirectionToBlockState(state, direction)) != null && !state.equals(updatedState)) {
                    cir.setReturnValue((Object)this.vminus$levelChunkSection.m_62991_(x, y, z, updatedState, flag));
                }
            }
        }
    }
}

