/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lixir.vminus.IconHandler;
import net.lixir.vminus.SoundHelper;
import net.lixir.vminus.VMinusConfig;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.helpers.DurabilityHelper;
import net.lixir.vminus.helpers.EnchantAndCurseHelper;
import net.lixir.vminus.mixins.items.ItemStackAccessor;
import net.lixir.vminus.registry.VMinusAttributes;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.EnchantmentVisionHelper;
import net.lixir.vminus.visions.util.VisionPropertyNameHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Unique
    private final ItemStack vminus$itemStack = (ItemStack)this;

    @Inject(method={"hurt"}, at={@At(value="RETURN")}, cancellable=true)
    public void vminus$hurt(int i, RandomSource random, ServerPlayer player, CallbackInfoReturnable<Boolean> cir) {
        JsonObject itemData;
        String replaceId;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (replaceId = VisionValueHandler.getFirstValidString(itemData = VisionHandler.getVisionData(this.vminus$itemStack), "break_replacement", this.vminus$itemStack)) != null && !replaceId.isEmpty()) {
            ItemStack findItem = this.vminus$itemStack;
            CompoundTag tag = findItem.m_41784_();
            ItemStack replacementStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(replaceId))));
            int slotIndex = player.m_150109_().m_36030_(findItem);
            if (slotIndex == -1) {
                for (int j = 0; j < player.m_150109_().f_35975_.size(); ++j) {
                    if (!((ItemStack)player.m_150109_().f_35975_.get(j)).equals(findItem)) continue;
                    slotIndex = 100 + j;
                    break;
                }
            }
            if (slotIndex == -1 && ((ItemStack)player.m_150109_().f_35976_.get(0)).equals(findItem)) {
                slotIndex = 150;
            }
            player.m_36246_(Stats.f_12983_.m_12902_((Object)findItem.m_41720_()));
            if (slotIndex != -1) {
                if (VisionValueHandler.isBooleanMet(null, "break_replacement", this.vminus$itemStack, "carry_nbt")) {
                    replacementStack.m_41751_(tag);
                }
                if (slotIndex < 100) {
                    player.m_150109_().m_6836_(slotIndex, replacementStack);
                } else if (slotIndex < 150) {
                    player.m_150109_().f_35975_.set(slotIndex - 100, (Object)replacementStack);
                } else {
                    player.m_150109_().f_35976_.set(0, (Object)replacementStack);
                }
            } else {
                this.vminus$itemStack.m_41774_(1);
            }
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="RETURN")}, cancellable=true)
    public void getBarWidth(CallbackInfoReturnable<Integer> cir) {
        if (this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:containers")))) {
            this.vminus$itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(capability -> {
                int numberOfSlots = capability.getSlots();
                double amount = 0.0;
                for (int i = 0; i < numberOfSlots; ++i) {
                    ItemStack itemStackInSlot = capability.getStackInSlot(i);
                    amount += (double)itemStackInSlot.m_41613_() / (double)itemStackInSlot.m_41741_();
                }
                float fullness = (float)amount / (float)numberOfSlots;
                int barWidth = (int)Math.floor(13.0f * fullness);
                cir.setReturnValue((Object)Math.min(barWidth, 13));
            });
        }
        if (this.vminus$itemStack.m_41782_() && this.vminus$itemStack.m_41783_().m_128441_("reinforcement")) {
            float durabilityRatio = (float)this.vminus$itemStack.m_41783_().m_128451_("reinforcement") / (float)this.vminus$itemStack.m_41783_().m_128451_("max_reinforcement");
            int barWidth = (int)Math.floor(13.0f * durabilityRatio);
            cir.setReturnValue((Object)Math.min(barWidth, 13));
        } else if (this.vminus$itemStack.m_41763_()) {
            float durabilityRatio = (float)DurabilityHelper.getDurability(this.vminus$itemStack) / (float)DurabilityHelper.getDurability(true, this.vminus$itemStack);
            int barWidth = (int)Math.floor(13.0f * durabilityRatio);
            cir.setReturnValue((Object)Math.min(barWidth, 13));
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="RETURN")}, cancellable=true)
    public void getBarColor(CallbackInfoReturnable<Integer> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        if (itemData != null && itemData.has("bar")) {
            int startColor = 4384126;
            int endColor = 2186818;
            try {
                String startColorString = VisionValueHandler.getFirstValidString(itemData, "bar", this.vminus$itemStack, "start_color");
                if (startColorString != null) {
                    startColor = Integer.decode(startColorString.trim());
                }
            }
            catch (NumberFormatException e) {
                VMinusMod.LOGGER.error("Invalid start_color format: " + itemData.get("start_color").getAsString());
            }
            try {
                String endColorString = VisionValueHandler.getFirstValidString(itemData, "bar", this.vminus$itemStack, "end_color");
                if (endColorString != null) {
                    endColor = Integer.decode(endColorString.trim());
                }
            }
            catch (NumberFormatException e) {
                VMinusMod.LOGGER.error("Invalid end_color format: " + itemData.get("end_color").getAsString());
            }
            float durabilityRatio = (float)DurabilityHelper.getDurability(this.vminus$itemStack) / (float)DurabilityHelper.getDurability(true, this.vminus$itemStack);
            int transitionColor = this.vminus$interpolateColor(endColor, startColor, durabilityRatio);
            cir.setReturnValue((Object)transitionColor);
            cir.cancel();
        } else {
            if (this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:containers")))) {
                this.vminus$itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                    int numberOfSlots = capability.getSlots();
                    int totalItems = 0;
                    int maxCapacity = 0;
                    for (int i = 0; i < numberOfSlots; ++i) {
                        ItemStack itemStackInSlot = capability.getStackInSlot(i);
                        totalItems += itemStackInSlot.m_41613_();
                        maxCapacity += itemStackInSlot.m_41741_();
                    }
                    float fullness = maxCapacity > 0 ? (float)totalItems / (float)maxCapacity : 0.0f;
                    int containerItemColor = this.vminus$rgbToColor(0.4f, 0.4f, 1.0f);
                    cir.setReturnValue((Object)containerItemColor);
                });
            }
            if (this.vminus$itemStack.m_41763_()) {
                if (this.vminus$itemStack.m_41783_().m_128471_("broken")) {
                    cir.setReturnValue((Object)Mth.m_14169_((float)0.01f, (float)0.0f, (float)0.35f));
                } else if (this.vminus$itemStack.m_41782_() && this.vminus$itemStack.m_41783_().m_128441_("reinforcement")) {
                    int startColor = 0x55FFFF;
                    int endColor = 2270527;
                    float durabilityRatio = (float)this.vminus$itemStack.m_41783_().m_128451_("reinforcement") / (float)this.vminus$itemStack.m_41783_().m_128451_("max_reinforcement");
                    int transitionColor = this.vminus$interpolateColor(endColor, startColor, durabilityRatio);
                    cir.setReturnValue((Object)transitionColor);
                } else {
                    int endColor;
                    int startColor;
                    float durabilityRatio = (float)DurabilityHelper.getDurability(this.vminus$itemStack) / (float)DurabilityHelper.getDurability(true, this.vminus$itemStack);
                    if (this.vminus$itemStack.m_41783_().m_128471_("death_durability")) {
                        startColor = 0xFF00FF;
                        endColor = 0x550055;
                    } else {
                        startColor = 6945834;
                        endColor = 0xE22626;
                    }
                    int transitionColor = this.vminus$interpolateColor(endColor, startColor, durabilityRatio);
                    cir.setReturnValue((Object)transitionColor);
                }
            }
        }
    }

    @Inject(method={"enchant"}, at={@At(value="HEAD")}, cancellable=true)
    public void enchant(Enchantment enchantment, int level, CallbackInfo ci) {
        if (EnchantmentVisionHelper.isBanned(enchantment)) {
            ci.cancel();
            return;
        }
        ItemStack itemstack = (ItemStack)this;
        CompoundTag tag = itemstack.m_41784_();
        int enchLimit = tag.m_128441_("enchantment_limit") ? tag.m_128451_("enchantment_limit") : 999;
        double currentTotalEnchantmentLevel = 0.0;
        if (itemstack.m_41793_()) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            for (Map.Entry entry : enchantments.entrySet()) {
                currentTotalEnchantmentLevel += (double)((Integer)entry.getValue()).intValue();
            }
        }
        if (currentTotalEnchantmentLevel + (double)level > (double)enchLimit) {
            ci.cancel();
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    public void isBarVisible(CallbackInfoReturnable<Boolean> cir) {
        if (this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:containers")))) {
            this.vminus$itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(capability -> {
                boolean hasItems = false;
                for (int i = 0; i < capability.getSlots(); ++i) {
                    if (capability.getStackInSlot(i).m_41613_() <= 0) continue;
                    hasItems = true;
                    break;
                }
                cir.setReturnValue((Object)hasItems);
            });
        }
        if (this.vminus$itemStack.m_41782_() && this.vminus$itemStack.m_41783_().m_128441_("reinforcement")) {
            if (this.vminus$itemStack.m_41783_().m_128451_("reinforcement") < this.vminus$itemStack.m_41783_().m_128451_("max_reinforcement")) {
                cir.setReturnValue((Object)true);
            }
        } else if (DurabilityHelper.getDurability(this.vminus$itemStack) < DurabilityHelper.getDurability(true, this.vminus$itemStack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setDamageValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void setDamageValue(int damage, CallbackInfo ci) {
        int minDamage;
        int dealtDamage;
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        CompoundTag tag = this.vminus$itemStack.m_41783_();
        if (itemData != null && itemData.has("min_damage") && (dealtDamage = this.vminus$itemStack.m_41773_()) < (minDamage = VisionValueHandler.isNumberMet(itemData, "min_damage", Integer.valueOf(0), this.vminus$itemStack).intValue())) {
            this.vminus$itemStack.m_41784_().m_128405_("Damage", minDamage);
            ci.cancel();
        }
        if (tag != null && tag.m_128441_("reinforcement") && tag.m_128451_("reinforcement") > 0) {
            int stillDamage = 0;
            tag.m_128405_("reinforcement", tag.m_128451_("reinforcement") - damage);
            if (tag.m_128451_("reinforcement") <= 0) {
                stillDamage = tag.m_128451_("reinforcement") * -1;
                tag.m_128473_("reinforcement");
                tag.m_128473_("max_reinforcement");
            }
            if (stillDamage > 0) {
                this.vminus$itemStack.m_41784_().m_128405_("Damage", this.vminus$itemStack.m_41773_() + stillDamage);
            }
            ci.cancel();
        }
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="RETURN")}, cancellable=true)
    public void getMaxDamage(CallbackInfoReturnable<Integer> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "durability");
        if (!propertyMet.isEmpty()) {
            int maxDurability = VisionValueHandler.isNumberMet(itemData, propertyMet, Integer.valueOf(cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 0), this.vminus$itemStack);
            cir.setReturnValue((Object)maxDurability);
        }
    }

    @Inject(method={"isDamageableItem"}, at={@At(value="RETURN")}, cancellable=true)
    public void isDamageableItem(CallbackInfoReturnable<Boolean> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "damageable");
        if (!propertyMet.isEmpty()) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(itemData, propertyMet, this.vminus$itemStack));
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="HEAD")}, cancellable=true)
    private void isEnchantable(CallbackInfoReturnable<Boolean> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "damageable");
        if (!propertyMet.isEmpty()) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(itemData, propertyMet, this.vminus$itemStack));
        }
    }

    @Inject(method={"isEdible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isEdible(CallbackInfoReturnable<Boolean> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        if (itemData != null && itemData.has("food_properties")) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getDrinkingSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDrinkingSound(CallbackInfoReturnable<SoundEvent> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        if (itemData != null && itemData.has("food_properties")) {
            JsonArray foodPropertiesArray = itemData.getAsJsonArray("food_properties");
            for (JsonElement element : foodPropertiesArray) {
                String soundName;
                SoundEvent eatSound;
                JsonObject foodProperties;
                if (!element.isJsonObject() || !(foodProperties = element.getAsJsonObject()).has("eat_sound") || (eatSound = SoundHelper.getSoundEventFromString(soundName = foodProperties.get("eat_sound").getAsString())) == null) continue;
                cir.setReturnValue((Object)eatSound);
                cir.cancel();
                return;
            }
        }
    }

    @Inject(method={"hasFoil"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasFoil(CallbackInfoReturnable<Boolean> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "foil");
        if (!propertyMet.isEmpty()) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(itemData, propertyMet, this.vminus$itemStack));
        }
    }

    @Inject(method={"getEatingSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEatingSound(CallbackInfoReturnable<SoundEvent> cir) {
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        if (itemData != null && itemData.has("food_properties")) {
            JsonArray foodPropertiesArray = itemData.getAsJsonArray("food_properties");
            for (JsonElement element : foodPropertiesArray) {
                String soundName;
                SoundEvent eatSound;
                JsonObject foodProperties;
                if (!element.isJsonObject() || !(foodProperties = element.getAsJsonObject()).has("eat_sound") || (eatSound = SoundHelper.getSoundEventFromString(soundName = foodProperties.get("eat_sound").getAsString())) == null) continue;
                cir.setReturnValue((Object)eatSound);
                cir.cancel();
                return;
            }
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void getUseDuration(CallbackInfoReturnable<Integer> cir) {
        int defaultDuration;
        int calculatedDuration;
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "use_duration");
        if (!propertyMet.isEmpty() && (calculatedDuration = VisionValueHandler.isNumberMet(itemData, propertyMet, Integer.valueOf(defaultDuration = 32), this.vminus$itemStack).intValue()) != defaultDuration) {
            cir.setReturnValue((Object)calculatedDuration);
        }
    }

    @Unique
    private int vminus$rgbToColor(float red, float green, float blue) {
        int r = Math.round(red * 255.0f);
        int g = Math.round(green * 255.0f);
        int b = Math.round(blue * 255.0f);
        return r << 16 | g << 8 | b;
    }

    @Unique
    private int vminus$interpolateColor(int startColor, int endColor, float ratio) {
        int r1 = startColor >> 16 & 0xFF;
        int g1 = startColor >> 8 & 0xFF;
        int b1 = startColor & 0xFF;
        int r2 = endColor >> 16 & 0xFF;
        int g2 = endColor >> 8 & 0xFF;
        int b2 = endColor & 0xFF;
        int r = Math.max(0, Math.min(255, (int)((float)r1 + (float)(r2 - r1) * ratio)));
        int g = Math.max(0, Math.min(255, (int)((float)g1 + (float)(g2 - g1) * ratio)));
        int b = Math.max(0, Math.min(255, (int)((float)b1 + (float)(b2 - b1) * ratio)));
        return r << 16 | g << 8 | b;
    }

    @Inject(method={"shouldShowInTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private static void vminus$shouldShowInTooltip(int p_41627_, ItemStack.TooltipPart p_41628_, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
        cir.cancel();
    }

    @Inject(method={"appendEnchantmentNames"}, at={@At(value="HEAD")}, cancellable=true)
    private static void appendEnchantmentNames(List<Component> enchantmentList, ListTag enchantments, CallbackInfo ci) {
        for (int i = 0; i < enchantments.size(); ++i) {
            CompoundTag compoundTag = enchantments.m_128728_(i);
            BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundTag)).ifPresent(enchantment -> enchantmentList.add((Component)Component.m_237113_((String)" ").m_7220_(enchantment.m_44700_(EnchantmentHelper.m_182438_((CompoundTag)compoundTag)))));
        }
        ci.cancel();
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTooltipLines(@Nullable Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        FoodProperties foodProperties;
        Block block;
        BlockState blockState;
        int light;
        Attribute attribute;
        Integer integer;
        if (!((Boolean)VMinusConfig.TOOLTIP_REWORK.get()).booleanValue()) {
            return;
        }
        ItemStackAccessor accessor = (ItemStackAccessor)this.vminus$itemStack;
        Item item = this.vminus$itemStack.m_41720_();
        ArrayList list = cir.getReturnValue() != null ? (List)cir.getReturnValue() : Lists.newArrayList();
        JsonObject itemData = VisionHandler.getVisionData(this.vminus$itemStack);
        CompoundTag tag = this.vminus$itemStack.m_41783_();
        int maxDurability = DurabilityHelper.getDurability(true, this.vminus$itemStack);
        int durability = DurabilityHelper.getDurability(this.vminus$itemStack);
        int enchantmentLimit = tag != null ? (int)tag.m_128459_("enchantment_limit") : 0;
        int enchants = this.vminus$itemStack.m_41793_() ? EnchantAndCurseHelper.getTotalEnchantments(this.vminus$itemStack) : 0;
        boolean echoed = tag != null && tag.m_128471_("echo");
        boolean deathDurability = tag != null && tag.m_128471_("death_durability");
        MutableComponent mutablecomponent = Component.m_237119_().m_7220_(this.vminus$itemStack.m_41786_()).m_130940_(this.vminus$itemStack.m_41791_().f_43022_);
        if (this.vminus$itemStack.m_41788_()) {
            mutablecomponent.m_130940_(ChatFormatting.ITALIC);
        }
        list.add(mutablecomponent);
        this.vminus$itemStack.m_41720_().m_7373_(this.vminus$itemStack, player == null ? null : player.m_9236_(), (List)list, flag);
        if (itemData != null) {
            List<String> tooltips = VisionValueHandler.getTooltips(itemData, this.vminus$itemStack, true);
            for (String tooltipD : tooltips) {
                list.add(Component.m_237113_((String)tooltipD));
            }
        }
        if (!flag.m_7050_() && !this.vminus$itemStack.m_41788_() && this.vminus$itemStack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)this.vminus$itemStack)) != null) {
            list.add(Component.m_237113_((String)("#" + integer)).m_130940_(ChatFormatting.GRAY));
        }
        int j = accessor.invokeGetHideFlags();
        if (this.vminus$itemStack.m_41782_()) {
            ItemStack.m_41709_((List)list, (ListTag)this.vminus$itemStack.m_41785_());
            if (this.vminus$itemStack.m_41783_().m_128425_("display", 10)) {
                CompoundTag compoundtag = this.vminus$itemStack.m_41783_().m_128469_("display");
                if (compoundtag.m_128425_("color", 99)) {
                    if (flag.m_7050_()) {
                        list.add(Component.m_237110_((String)"item.color", (Object[])new Object[]{String.format("#%06X", compoundtag.m_128451_("color"))}).m_130940_(ChatFormatting.GRAY));
                    } else {
                        list.add(Component.m_237115_((String)"item.dyed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                }
                if (compoundtag.m_128435_("Lore") == 9) {
                    ListTag listtag = compoundtag.m_128437_("Lore", 8);
                    for (int i = 0; i < listtag.size(); ++i) {
                        String s = listtag.m_128778_(i);
                        try {
                            MutableComponent mutablecomponent1 = Component.Serializer.m_130701_((String)s);
                            if (mutablecomponent1 == null) continue;
                            list.add(ComponentUtils.m_130750_((MutableComponent)mutablecomponent1, (Style)Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true))));
                            continue;
                        }
                        catch (Exception exception) {
                            compoundtag.m_128473_("Lore");
                        }
                    }
                }
            }
        }
        ArrayList attributeTooltips = new ArrayList();
        HashMap<EquipmentSlot, Map> mergedAttributes = new HashMap<EquipmentSlot, Map>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Multimap attributeModifiers = this.vminus$itemStack.m_41638_(slot);
            for (Map.Entry entry : attributeModifiers.entries()) {
                attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                mergedAttributes.computeIfAbsent(slot, k -> new HashMap()).merge(attribute, modifier, (existing, newModifier) -> {
                    double combinedAmount = existing.m_22217_() == newModifier.m_22217_() ? (newModifier.m_22217_() == AttributeModifier.Operation.ADDITION ? existing.m_22218_() + newModifier.m_22218_() : existing.m_22218_() * newModifier.m_22218_()) : existing.m_22218_();
                    return new AttributeModifier(newModifier.m_22214_(), combinedAmount, newModifier.m_22217_());
                });
            }
        }
        if (this.vminus$itemStack.m_41720_() instanceof BlockItem && (light = (blockState = (block = ((BlockItem)this.vminus$itemStack.m_41720_()).m_40614_()).m_49966_()).m_60791_()) > 0) {
            list.add(Component.m_237113_((String)(" " + IconHandler.getIcon("luminance") + IconHandler.getIcon("blueColor") + " " + light + " Luminance")));
        }
        ArrayList<MutableComponent> tempList = new ArrayList<MutableComponent>();
        for (Map.Entry entry : mergedAttributes.entrySet()) {
            EquipmentSlot slot;
            slot = (EquipmentSlot)entry.getKey();
            Map attributes = (Map)entry.getValue();
            if (!attributes.isEmpty()) {
                if (mergedAttributes.size() > 1) {
                    tempList.add(Component.m_237115_((String)("item.modifiers." + slot.m_20751_())).m_130940_(ChatFormatting.GRAY));
                }
                for (Map.Entry entry2 : attributes.entrySet()) {
                    attribute = (Attribute)entry2.getKey();
                    AttributeModifier attributeModifier = (AttributeModifier)entry2.getValue();
                    double d0 = attributeModifier.m_22218_();
                    double d1 = attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute == Attributes.f_22278_ ? d0 * 10.0 : d0) : d0 * 100.0;
                    ResourceLocation attributeResourceLocation = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute);
                    String attributeId = attributeResourceLocation != null ? attributeResourceLocation.toString() : "";
                    String icon = IconHandler.getIconForAttribute(attributeId);
                    if (icon == null) {
                        icon = "";
                    }
                    boolean colorOverride = false;
                    if (attributeId.equals("vminus:mob_detection_range")) {
                        colorOverride = true;
                    }
                    MutableComponent iconComponent = Component.m_237113_((String)(" " + icon)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
                    MutableComponent attributeComponent = Component.m_237115_((String)attribute.m_22087_());
                    MutableComponent modifierComponent = null;
                    if (attribute == Attributes.f_22283_) {
                        String attackSpeedType = null;
                        attackSpeedType = d1 != 0.0 && attributeModifier.m_22217_() != AttributeModifier.Operation.ADDITION ? (d1 < -80.0 ? "Slow" : (d1 <= -65.0 ? "Medium" : (d1 <= -50.0 ? "Fast" : "Very Fast"))) : (d1 >= -1.5 ? "Very Fast" : (d1 >= -2.0 ? "Fast" : (d1 >= -2.5 ? "Medium" : (d1 <= -3.0 ? "Very Slow" : "Slow"))));
                        modifierComponent = Component.m_237113_((String)"");
                        MutableComponent attackSpeed = Component.m_237113_((String)(attackSpeedType + " "));
                        modifierComponent.m_7220_((Component)attackSpeed);
                        modifierComponent.m_7220_((Component)attributeComponent).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE));
                    } else if (d0 > 0.0) {
                        modifierComponent = Component.m_237110_((String)("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), attributeComponent}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE));
                    } else if (colorOverride) {
                        modifierComponent = Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 * -1.0), attributeComponent}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE));
                    } else if (d0 < 0.0) {
                        modifierComponent = Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), attributeComponent}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                    }
                    if (modifierComponent == null) continue;
                    Boolean dontRenderAttribute = false;
                    if (attribute == VMinusAttributes.MININGSPEED.get() && this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:tooltip/hide_mining_speed")))) {
                        dontRenderAttribute = true;
                    }
                    if (dontRenderAttribute.booleanValue()) continue;
                    tempList.add(iconComponent.m_7220_((Component)modifierComponent));
                }
            }
            Collections.sort(tempList, new Comparator<Component>(){

                @Override
                public int compare(Component o1, Component o2) {
                    return o2.getString().compareTo(o1.getString());
                }
            });
            attributeTooltips.addAll(tempList);
        }
        list.addAll(attributeTooltips);
        Boolean unbreakable = false;
        if (this.vminus$itemStack.m_41782_()) {
            ListTag listtag2;
            ListTag listtag1;
            if (this.vminus$itemStack.m_41783_().m_128471_("Unbreakable")) {
                list.add(Component.m_237115_((String)"item.unbreakable").m_130940_(ChatFormatting.BLUE));
                unbreakable = true;
            }
            if (this.vminus$itemStack.m_41783_().m_128425_("CanDestroy", 9) && !(listtag1 = this.vminus$itemStack.m_41783_().m_128437_("CanDestroy", 8)).isEmpty()) {
                list.add(Component.m_237119_());
                list.add(Component.m_237115_((String)"item.canBreak").m_130940_(ChatFormatting.GRAY));
                for (int k2 = 0; k2 < listtag1.size(); ++k2) {
                    list.addAll(accessor.getExpandBlockState(listtag1.m_128778_(k2)));
                }
            }
            if (this.vminus$itemStack.m_41783_().m_128425_("CanPlaceOn", 9) && !(listtag2 = this.vminus$itemStack.m_41783_().m_128437_("CanPlaceOn", 8)).isEmpty()) {
                list.add(Component.m_237119_());
                list.add(Component.m_237115_((String)"item.canPlace").m_130940_(ChatFormatting.GRAY));
                for (int l = 0; l < listtag2.size(); ++l) {
                    list.addAll(accessor.getExpandBlockState(listtag2.m_128778_(l)));
                }
            }
        }
        if ((foodProperties = item.m_41473_()) != null && this.vminus$itemStack.m_41614_()) {
            String healSpeed = "";
            String healText = "";
            if (!foodProperties.m_38749_().isEmpty()) {
                foodProperties.m_38749_().forEach(effectPair -> {
                    String effectName = ((MobEffectInstance)effectPair.getFirst()).m_19544_().m_19482_().getString();
                    int duration = ((MobEffectInstance)effectPair.getFirst()).m_19557_();
                    int amplifier = ((MobEffectInstance)effectPair.getFirst()).m_19564_();
                    float chance = ((Float)effectPair.getSecond()).floatValue();
                    int durationSeconds = duration / 20;
                    boolean isBadEffect = !((MobEffectInstance)effectPair.getFirst()).m_19544_().m_19486_();
                    String icon = !isBadEffect ? IconHandler.getIcon("effect") + IconHandler.getIcon("grayColor") : IconHandler.getIcon("bad_effect") + IconHandler.getIcon("redColor");
                    MutableComponent effectLevel = Component.m_237115_((String)("potion.potency." + amplifier));
                    String durationMinutes = String.format("%02d", durationSeconds / 60);
                    String durationSecondsString = String.format("%02d", durationSeconds % 60);
                    String durationString = durationMinutes + ":" + durationSecondsString;
                    String chanceString = chance < 1.0f ? " [" + (int)(chance * 100.0f) + "%]" : "";
                    MutableComponent finalString = Component.m_237113_((String)(" " + icon + effectName + (!effectLevel.toString().isEmpty() ? " " : "")));
                    list.add(finalString.m_7220_((Component)effectLevel).m_7220_((Component)Component.m_237113_((String)((!isBadEffect ? IconHandler.getIcon("grayColor") : IconHandler.getIcon("redColor")) + " (" + durationString + ")" + chanceString))));
                });
            }
            if (ModList.get().isLoaded("detour")) {
                if (this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("detour:food/fast_healing_speed")))) {
                    healSpeed = IconHandler.getIcon("fast_hunger_shank");
                    healText = "Fast Saturation";
                } else if (this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("detour:food/slow_healing_speed")))) {
                    healSpeed = IconHandler.getIcon("slow_hunger_shank");
                    healText = "Slow Saturation";
                } else {
                    healSpeed = IconHandler.getIcon("hunger_shank");
                    healText = "Saturation";
                }
            } else {
                healSpeed = IconHandler.getIcon("hunger_shank");
                healText = "Nutrition";
            }
            list.add(Component.m_237113_((String)(" " + healSpeed + IconHandler.getIcon("blueColor") + foodProperties.m_38744_() + " " + healText)));
            if (!ModList.get().isLoaded("detour")) {
                double saturation = foodProperties.m_38745_();
                String saturationString = "";
                if (saturation <= 0.2) {
                    saturationString = "Poor";
                } else if (saturation <= 0.6 && saturation > 0.2) {
                    saturationString = "Low";
                } else if (saturation <= 1.2 && saturation > 0.6) {
                    saturationString = "Normal";
                } else if (saturation <= 1.6 && saturation > 1.2) {
                    saturationString = "Good";
                } else if (saturation > 1.6) {
                    saturationString = "Supernatural";
                }
                list.add(Component.m_237113_((String)(" " + IconHandler.getIcon("saturation") + IconHandler.getIcon("blueColor") + saturationString + " Saturation")));
            }
            double eatDuration = item.m_8105_(this.vminus$itemStack);
            list.add(Component.m_237113_((String)(" " + IconHandler.getIcon("eating_duration") + IconHandler.getIcon("blueColor") + new DecimalFormat("#.#").format(eatDuration / 20.0) + "s Eating Duration")));
        }
        StringBuilder genericStats = new StringBuilder();
        if (!(maxDurability < 1 || this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:cosmetic"))) || echoed || unbreakable.booleanValue())) {
            genericStats.append(deathDurability ? IconHandler.getIcon("death_durability") : IconHandler.getIcon("anvil")).append(tag != null && tag.m_128441_("reinforcement") ? IconHandler.getIcon("aquaColor") : IconHandler.getIcon("grayColor")).append(durability).append(IconHandler.getIcon("darkGrayColor")).append("/").append(maxDurability).append(" ");
        }
        if (enchantmentLimit >= 1 && !this.vminus$itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("vminus:unenchantable"))) && (this.vminus$itemStack.m_41792_() || this.vminus$itemStack.m_41793_())) {
            genericStats.append(IconHandler.getIcon("rune") + IconHandler.getIcon("grayColor") + enchants + IconHandler.getIcon("darkGrayColor") + "/" + enchantmentLimit + " ");
        }
        if (!genericStats.toString().isEmpty()) {
            String genericStatsString = genericStats.toString().replaceAll("\\s+$", "");
            list.add(Component.m_237113_((String)genericStatsString));
        }
        if (itemData != null) {
            List<String> tooltips = VisionValueHandler.getTooltips(itemData, this.vminus$itemStack, false);
            for (String string : tooltips) {
                list.add(Component.m_237113_((String)string));
            }
        }
        ForgeEventFactory.onItemTooltip((ItemStack)this.vminus$itemStack, (Player)player, (List)list, (TooltipFlag)flag);
        if (flag.m_7050_()) {
            if (player.m_150110_().f_35937_) {
                list.add(Component.m_237113_((String)BuiltInRegistries.f_257033_.m_7981_((Object)this.vminus$itemStack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.vminus$itemStack.m_41782_()) {
                list.add(Component.m_237110_((String)"item.nbt_tags", (Object[])new Object[]{this.vminus$itemStack.m_41783_().m_128431_().size()}).m_130940_(ChatFormatting.DARK_GRAY));
                if (tag != null) {
                    String json = tag.toString();
                    MutableComponent nbtText = Component.m_237113_((String)json).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY));
                    list.add(nbtText);
                }
            }
        }
        cir.setReturnValue((Object)list);
    }
}

