/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.entities;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Slime.class})
public abstract class SlimeMixin
extends Mob
implements Enemy {
    @Unique
    private final Slime slime = (Slime)this;

    protected SlimeMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")}, cancellable=true)
    private void remove(Entity.RemovalReason removalReason, CallbackInfo ci) {
        int size = this.slime.m_33632_();
        if (!this.slime.m_9236_().f_46443_ && size > 1 && this.slime.m_21224_()) {
            Component customName = this.slime.m_7770_();
            boolean noAi = this.slime.m_21525_();
            float offset = (float)size / 4.0f;
            int newSize = size - 1;
            int splitCount = 2 + this.slime.m_217043_().m_188503_(3);
            String variant = "";
            if (this.slime.getPersistentData().m_128441_("variant")) {
                variant = this.slime.getPersistentData().m_128461_("variant");
            }
            for (int i = 0; i < splitCount; ++i) {
                float offsetX = ((float)(i % 2) - 0.5f) * offset;
                float offsetZ = ((float)(i / 2) - 0.5f) * offset;
                Slime newSlime = (Slime)this.slime.m_6095_().m_20615_(this.slime.m_9236_());
                if (newSlime == null) continue;
                if (this.slime.m_21532_()) {
                    newSlime.m_21530_();
                }
                newSlime.m_6593_(customName);
                newSlime.m_21557_(noAi);
                newSlime.m_20331_(this.slime.m_20147_());
                newSlime.m_7839_(newSize, true);
                newSlime.m_7678_(this.slime.m_20185_() + (double)offsetX, this.slime.m_20186_() + 0.5, this.slime.m_20189_() + (double)offsetZ, this.slime.m_217043_().m_188501_() * 360.0f, 0.0f);
                newSlime.getPersistentData().m_128359_("variant", variant);
                this.slime.m_9236_().m_7967_((Entity)newSlime);
            }
        }
        super.m_142687_(removalReason);
        ci.cancel();
    }
}

