/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.entities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.lixir.vminus.SoundHelper;
import net.lixir.vminus.visions.VisionHandler;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private final Player vminus$player = (Player)this;

    protected PlayerMixin(EntityType<? extends LivingEntity> p_250508_, Level p_250289_) {
        super(p_250508_, p_250289_);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")}, cancellable=true)
    public void eat(Level level, ItemStack itemstack, CallbackInfoReturnable<ItemStack> cir) {
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        this.vminus$player.m_36324_().m_38712_(itemstack.m_41720_(), itemstack);
        if (itemData != null && itemData.has("food_properties")) {
            JsonArray foodPropertiesArray = itemData.getAsJsonArray("food_properties");
            for (JsonElement element : foodPropertiesArray) {
                String soundName;
                SoundEvent eatSound;
                JsonObject foodProperties;
                if (!element.isJsonObject() || !(foodProperties = element.getAsJsonObject()).has("burp_sound") || (eatSound = SoundHelper.getSoundEventFromString(soundName = foodProperties.get("b,urp_sound").getAsString())) == null) continue;
                this.vminus$player.m_5496_(eatSound, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
        cir.setReturnValue((Object)super.m_5584_(level, itemstack));
    }
}

