/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.entities;

import com.google.gson.JsonObject;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private final Entity entity = (Entity)this;

    @Inject(method={"isSilent"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSilent(CallbackInfoReturnable<Boolean> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.entity.m_6095_());
        if (visionData != null && visionData.has("silent")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(visionData, "silent", this.entity.m_6095_()));
        }
    }

    @Inject(method={"dampensVibrations"}, at={@At(value="HEAD")}, cancellable=true)
    private void dampensVibrations(CallbackInfoReturnable<Boolean> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.entity.m_6095_());
        if (visionData != null && visionData.has("dampens_vibrations")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(visionData, "dampens_vibrations", this.entity.m_6095_()));
        }
    }
}

