/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.enchantments;

import net.lixir.vminus.visions.util.EnchantmentVisionHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @Unique
    private final Enchantment enchantment = (Enchantment)this;

    @Inject(method={"getMinLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMinLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getMinLevel(this.enchantment, cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 1));
    }

    @Inject(method={"getMaxLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMaxLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getMaxLevel(this.enchantment, cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 1));
    }

    @Inject(method={"isTreasureOnly"}, at={@At(value="RETURN")}, cancellable=true)
    private void isTreasureOnly(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isTreasure(this.enchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isCurse"}, at={@At(value="RETURN")}, cancellable=true)
    private void isCurse(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isCurse(this.enchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"canEnchant"}, at={@At(value="RETURN")}, cancellable=true)
    private void canEnchant(ItemStack itemstack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.canEnchant(this.enchantment, itemstack, (Boolean)cir.getReturnValue()));
    }

    @Inject(method={"isCompatibleWith"}, at={@At(value="RETURN")}, cancellable=true)
    private void isCompatibleWith(Enchantment otherEnchantment, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isCompatible(this.enchantment, otherEnchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isTradeable"}, at={@At(value="RETURN")}, cancellable=true)
    private void isTradeable(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isTradeable(this.enchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isDiscoverable"}, at={@At(value="RETURN")}, cancellable=true)
    private void isDiscoverable(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isDiscoverable(this.enchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRarity(CallbackInfoReturnable<Enchantment.Rarity> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getRarity(this.enchantment, (Enchantment.Rarity)cir.getReturnValue()));
    }
}

