/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.lixir.vminus.mixins.crafting.IngredientAccessor;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionPropertyHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class})
public abstract class IngredientMixin {
    @Unique
    private final Ingredient vminus$ingredient = (Ingredient)this;

    @Inject(method={"test*"}, at={@At(value="HEAD")}, cancellable=true)
    public void vminus$test(@Nullable ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        IngredientAccessor accessor = (IngredientAccessor)this.vminus$ingredient;
        if (itemStack == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (accessor.invokeIsEmpty()) {
            cir.setReturnValue((Object)itemStack.m_41619_());
            return;
        }
        cir.setReturnValue((Object)VisionPropertyHandler.matchesIngredient(itemStack, accessor.getValues()));
    }

    @Inject(method={"getItems"}, at={@At(value="HEAD")}, cancellable=true)
    public void vminus$getItems(CallbackInfoReturnable<ItemStack[]> cir) {
        ArrayList<ItemStack> replacedItems = new ArrayList<ItemStack>();
        IngredientAccessor accessor = (IngredientAccessor)this.vminus$ingredient;
        for (Ingredient.Value value : accessor.getValues()) {
            for (ItemStack stack : value.m_6223_()) {
                JsonObject visionData;
                ItemStack replacementStack = VisionPropertyHandler.getIngredientReplacement(stack, visionData = VisionHandler.getVisionData(stack));
                if (replacementStack != null) {
                    replacedItems.add(replacementStack);
                    continue;
                }
                if (VisionPropertyHandler.isBanned(stack, visionData)) continue;
                replacedItems.add(stack);
            }
        }
        cir.setReturnValue((Object)replacedItems.toArray(new ItemStack[0]));
    }
}

