/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.client;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.lixir.vminus.mixins.client.GuiGraphicsAccessor;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    @Unique
    private final GuiGraphics vminus$guiGraphics = (GuiGraphics)this;

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="TAIL")})
    public void renderItemDecorations(Font font, ItemStack itemstack, int x, int y, @Nullable String customText, CallbackInfo ci) {
        if (!itemstack.m_41619_()) {
            this.renderCustomTexture(itemstack, x, y);
        }
    }

    private void renderCustomTexture(ItemStack itemstack, int x, int y) {
        GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)this.vminus$guiGraphics;
        JsonObject visionData = VisionHandler.getVisionData(itemstack);
        accessor.getPoseStack().m_85836_();
        ResourceLocation customTexture = this.getCustomTextureForItem(itemstack);
        if (customTexture != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)customTexture);
            if (VisionValueHandler.isBooleanMet(visionData, "front", itemstack)) {
                accessor.getPoseStack().m_252880_(0.0f, 0.0f, 200.0f);
            } else {
                accessor.getPoseStack().m_252880_(0.0f, 0.0f, 0.0f);
            }
            GuiGraphics guiGraphics = (GuiGraphics)this;
            guiGraphics.m_280163_(customTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        accessor.getPoseStack().m_85849_();
    }

    private ResourceLocation getCustomTextureForItem(ItemStack itemstack) {
        String decoString;
        JsonObject visionData = VisionHandler.getVisionData(itemstack);
        if (visionData != null && visionData.has("decorator") && (decoString = VisionValueHandler.getFirstValidString(visionData, "decorator", itemstack)) != null && !decoString.isEmpty()) {
            return new ResourceLocation(decoString);
        }
        return null;
    }
}

