/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.blocks;

import com.google.gson.JsonObject;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Unique
    private final BlockState vminus$state = (BlockState)this;

    @Inject(method={"getLightEmission"}, at={@At(value="HEAD")}, cancellable=true)
    private void getLightEmission(CallbackInfoReturnable<Integer> cir) {
        Block block = this.vminus$state.m_60734_();
        JsonObject blockData = VisionHandler.getVisionData(block);
        if (blockData != null && blockData.has("light_level")) {
            int lightLevel = VisionValueHandler.isNumberMet(blockData, "light_level", Integer.valueOf(cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 0), block);
            cir.setReturnValue((Object)Math.min(Math.max(lightLevel, 0), 15));
        }
    }

    @Inject(method={"emissiveRendering"}, at={@At(value="HEAD")}, cancellable=true)
    private void emissiveRendering(CallbackInfoReturnable<Boolean> cir) {
        Block block = this.vminus$state.m_60734_();
        JsonObject blockData = VisionHandler.getVisionData(block);
        if (blockData != null && blockData.has("emissive_rendering")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(blockData, "emissive_rendering", block));
        }
    }

    @Inject(method={"canOcclude"}, at={@At(value="HEAD")}, cancellable=true)
    private void canOcclude(CallbackInfoReturnable<Boolean> cir) {
        Block block = this.vminus$state.m_60734_();
        JsonObject blockData = VisionHandler.getVisionData(block);
        if (blockData != null && blockData.has("can_occlude")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(blockData, "can_occlude", block));
        }
    }

    @Inject(method={"isRedstoneConductor"}, at={@At(value="HEAD")}, cancellable=true)
    private void isRedstoneConductor(CallbackInfoReturnable<Boolean> cir) {
        Block block = this.vminus$state.m_60734_();
        JsonObject blockData = VisionHandler.getVisionData(block);
        if (blockData != null && blockData.has("redstone_conductor")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(blockData, "redstone_conductor", block));
        }
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDestroySpeed(BlockGetter p_60801_, BlockPos p_60802_, CallbackInfoReturnable<Float> cir) {
        Block block = this.vminus$state.m_60734_();
        JsonObject blockData = VisionHandler.getVisionData(block);
        if (blockData != null && blockData.has("destroy_time")) {
            float destroyTime = VisionValueHandler.isNumberMet(blockData, "destroy_time", Float.valueOf(cir.getReturnValue() != null ? ((Float)cir.getReturnValue()).floatValue() : 0.0f), block).floatValue();
            cir.setReturnValue((Object)Float.valueOf(Math.max(-1.0f, destroyTime)));
        }
    }

    @Inject(method={"isValidSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValidSpawn(CallbackInfoReturnable<Boolean> cir) {
        if (this.vminus$state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("vminus:override_valid_spawning")))) {
            cir.setReturnValue((Object)true);
        }
    }
}

