/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import java.util.Collection;
import net.lixir.vminus.registry.VMinusAttributes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerCriticalHitEventHandler {
    private static final float DEFAULT_DAMAGE_MODIFIER = 1.5f;
    private static final float DETOUR_DAMAGE_MODIFIER = 1.15f;

    @SubscribeEvent
    public static void onPlayerCriticalHit(CriticalHitEvent event) {
        Player entity = event.getEntity();
        event.setDamageModifier((ModList.get().isLoaded("detour") ? 1.15f : 1.5f) + PlayerCriticalHitEventHandler.getAttributeModifiers((LivingEntity)entity));
    }

    private static float getAttributeModifiers(LivingEntity entity) {
        float modifierSum = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = entity.m_6844_(slot);
            if (itemStack.m_41619_()) continue;
            modifierSum += PlayerCriticalHitEventHandler.getCritValueFromItem(itemStack, slot, (Attribute)VMinusAttributes.CRITICALDAMAGE.get());
        }
        if (ModList.get().isLoaded("detour")) {
            float fallDistance = entity.f_19789_;
            float fallDistanceModifier = Math.min(fallDistance * 0.05f, 0.7f);
            modifierSum += fallDistanceModifier;
        }
        return modifierSum;
    }

    private static float getCritValueFromItem(ItemStack itemStack, EquipmentSlot slot, Attribute attribute) {
        Collection modifiers = itemStack.m_41638_(slot).get((Object)attribute);
        if (modifiers != null && !modifiers.isEmpty()) {
            return (float)modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
        }
        return 0.0f;
    }
}

