/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class LivingTickEventHandler {
    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        Level world = event.getEntity().m_9236_();
        LivingEntity entity = event.getEntity();
        if (entity == null || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (world.m_6106_().m_6793_() % 4L == 0L && entity instanceof LivingEntity) {
            Collection activeEffects;
            List<String> visibleEffects;
            LivingEntity livingEntity = entity;
            if (!LivingTickEventHandler.isSpectator((Entity)entity) && !(visibleEffects = LivingTickEventHandler.getVisibleEffects(activeEffects = livingEntity.m_21220_())).isEmpty()) {
                String currentEffect = LivingTickEventHandler.getRandomEffect(visibleEffects);
                double[] spawnCoordinates = LivingTickEventHandler.getSpawnCoordinates((Entity)entity);
                LivingTickEventHandler.spawnParticleForEffect(currentEffect, serverWorld, spawnCoordinates, (Entity)entity);
            }
        }
    }

    private static boolean isSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            GameType gameMode = serverPlayer.f_8941_.m_9290_();
            return gameMode == GameType.SPECTATOR;
        }
        if (entity.m_9236_().m_5776_() && entity instanceof Player) {
            PlayerInfo playerInfo;
            Player player = (Player)entity;
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            if (connection != null && (playerInfo = connection.m_104949_(player.m_36316_().getId())) != null) {
                GameType gameMode = playerInfo.m_105325_();
                return gameMode == GameType.SPECTATOR;
            }
        }
        return false;
    }

    private static List<String> getVisibleEffects(Collection<MobEffectInstance> activeEffects) {
        ArrayList<String> effects = new ArrayList<String>();
        for (MobEffectInstance effectInstance : activeEffects) {
            if (!effectInstance.m_19572_()) continue;
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effectInstance.m_19544_());
            effects.add(effectId.toString());
        }
        return effects;
    }

    private static String getRandomEffect(List<String> effects) {
        return effects.get(Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)(effects.size() - 1)));
    }

    private static double[] getSpawnCoordinates(Entity entity) {
        double spawnX = entity.m_20185_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)((double)(entity.m_20205_() / 2.0f * -1.0f) - 0.3), (double)((double)(entity.m_20205_() / 2.0f) + 0.3));
        double spawnY = entity.m_20186_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.0, (double)entity.m_20206_());
        double spawnZ = entity.m_20189_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)((double)(entity.m_20205_() / 2.0f * -1.0f) - 0.3), (double)((double)(entity.m_20205_() / 2.0f) + 0.3));
        return new double[]{spawnX, spawnY, spawnZ};
    }

    private static void spawnParticleForEffect(String effect, ServerLevel world, double[] spawnCoords, Entity entity) {
        SimpleParticleType simpleParticleType;
        String effectString;
        ResourceLocation particleLocation;
        ParticleType particleType;
        ResourceLocation effectLocation = new ResourceLocation(effect);
        MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
        if (mobEffect == null) {
            return;
        }
        JsonObject visionData = VisionHandler.getVisionData(mobEffect);
        if (visionData != null && visionData.has("particle") && (particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleLocation = new ResourceLocation(effectString = VisionValueHandler.getFirstValidString(visionData, "particle")))) instanceof SimpleParticleType && (simpleParticleType = (SimpleParticleType)particleType) != null) {
            world.m_8767_((ParticleOptions)simpleParticleType, spawnCoords[0], spawnCoords[1], spawnCoords[2], 1, 0.0, 0.0, 0.0, Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.01, (double)0.03));
        }
    }
}

