/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import java.util.Collection;
import net.lixir.vminus.helpers.ProtectionHelper;
import net.lixir.vminus.registry.VMinusAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LivingHurtEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingHurt(LivingHurtEvent event) {
        float amount;
        Entity entity = event.getSource().m_7639_();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity _entity = (LivingEntity)entity;
        DamageSource damageSource = event.getSource();
        float damage = amount = event.getAmount();
        float modifierSum = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = _entity.m_6844_(slot);
            if (itemStack.m_41619_()) continue;
            int i = (int)_entity.m_21233_();
            while ((float)i > _entity.m_21223_()) {
                modifierSum += LivingHurtEventHandler.getAttributeValueFromItem(itemStack, slot, (Attribute)VMinusAttributes.HEALTHLOSTSTATBOOST.get());
                --i;
            }
        }
        damage = ProtectionHelper.applyProtection(damage, _entity, damageSource, "vminus:fire_protection", "vminus:protection/fire");
        damage = ProtectionHelper.applyProtection(damage, _entity, damageSource, "vminus:blast_protection", "vminus:protection/blast");
        damage = ProtectionHelper.applyProtection(damage, _entity, damageSource, "vminus:magic_protection", "vminus:protection/magic");
        damage = ProtectionHelper.applyProtection(damage, _entity, damageSource, "vminus:fall_protection", "vminus:protection/fall");
        damage = ProtectionHelper.applyProtection(damage, _entity, damageSource, "vminus:blunt_protection", "vminus:protection/blast");
        event.setAmount(damage + amount * modifierSum);
    }

    private static float getAttributeValueFromItem(ItemStack itemStack, EquipmentSlot slot, Attribute attribute) {
        Collection modifiers = itemStack.m_41638_(slot).get((Object)attribute);
        if (modifiers != null && !modifiers.isEmpty()) {
            return (float)modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
        }
        return 0.0f;
    }
}

