/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.lixir.vminus.IconHandler;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ItemTooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            String validInspect;
            String inspectString;
            List tooltip = event.getToolTip();
            ItemStack itemstack = event.getItemStack();
            if (tooltip == null) {
                return;
            }
            Item item = itemstack.m_41720_();
            String itemId = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString();
            boolean inspectable = false;
            int inspectNum = 1;
            boolean altDown = Screen.m_96639_();
            String inspectStart = IconHandler.getIcon("inspect_bauble") + IconHandler.getIcon("darkGreenColor");
            while (!(inspectString = I18n.m_118938_((String)("inspection.item." + inspectNum + "." + (validInspect = itemId.replaceAll(":", "."))), (Object[])new Object[0])).equals("inspection.item." + inspectNum + "." + validInspect)) {
                inspectable = true;
                if (!altDown) break;
                tooltip.add(Component.m_237113_((String)(inspectStart + inspectString)));
                ++inspectNum;
            }
            JsonObject itemData = VisionHandler.getVisionData(itemstack);
            if (inspectable || VisionValueHandler.isBooleanMet(itemData, "inspectable", itemstack)) {
                if (!altDown) {
                    tooltip.add(Component.m_237113_((String)("\u00a79[ALT" + IconHandler.getIcon("inspect") + "\u00a79]")));
                } else {
                    tooltip.add(Component.m_237113_((String)("\u00a78[ALT" + IconHandler.getIcon("inspect_held") + "\u00a78]")));
                }
            }
        }
    }
}

