/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.lixir.vminus.visions.VisionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityPlaceEventHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        double z;
        double y;
        LevelAccessor world = event.getLevel();
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        double x = entity.m_20185_();
        BlockPos pos = BlockPos.m_274561_((double)x, (double)(y = entity.m_20186_()), (double)(z = entity.m_20189_()));
        BlockState blockState = world.m_8055_(pos);
        JsonObject blockData = VisionHandler.getVisionData(blockState.m_60734_());
        if (blockData != null && blockData.has("place_blockstate")) {
            JsonArray blockStates = blockData.getAsJsonArray("place_blockstate");
            block10: for (JsonElement element : blockStates) {
                String type;
                JsonObject stateData = element.getAsJsonObject();
                String name = stateData.get("name").getAsString();
                switch (type = stateData.get("type").getAsString()) {
                    case "boolean": {
                        boolean boolValue = stateData.get("value").getAsBoolean();
                        Property property = blockState.m_60734_().m_49965_().m_61081_(name);
                        if (!(property instanceof BooleanProperty)) continue block10;
                        BooleanProperty booleanProp = (BooleanProperty)property;
                        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)booleanProp, (Comparable)Boolean.valueOf(boolValue)), 3);
                        break;
                    }
                    case "int": {
                        IntegerProperty intProp;
                        int intValue = stateData.get("value").getAsInt();
                        Property property = blockState.m_60734_().m_49965_().m_61081_(name);
                        if (!(property instanceof IntegerProperty) || !(intProp = (IntegerProperty)property).m_6908_().contains(intValue)) continue block10;
                        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)intProp, (Comparable)Integer.valueOf(intValue)), 3);
                        break;
                    }
                    case "enum": {
                        EnumProperty enumProp;
                        String enumValue = stateData.get("value").getAsString();
                        Property property = blockState.m_60734_().m_49965_().m_61081_(name);
                        if (!(property instanceof EnumProperty) || !(enumProp = (EnumProperty)property).m_6215_(enumValue).isPresent()) continue block10;
                        world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)enumProp, (Comparable)((Object)((Enum)enumProp.m_6215_(enumValue).get()))), 3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported block state type: " + type);
                    }
                }
            }
        }
    }
}

