/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.helpers.MobVariantHelper;
import net.lixir.vminus.network.mobvariants.MobVariantSyncPacket;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionPropertyHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EntityJoinLevelEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        JsonObject visionData = VisionHandler.getVisionData(entity.m_6095_());
        if (VisionValueHandler.isBooleanMet(visionData, "banned", entity)) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
        if (entity instanceof LivingEntity && visionData != null && visionData.has("base_attributes")) {
            JsonArray baseAttributesArray = visionData.getAsJsonArray("base_attributes");
            for (JsonElement element : baseAttributesArray) {
                AttributeInstance attributeInstance;
                JsonObject elementData = element.getAsJsonObject();
                if (!elementData.has("id") || !elementData.has("value")) continue;
                String attributeId = elementData.get("id").getAsString();
                double value = elementData.get("value").getAsDouble();
                LivingEntity livingEntity = (LivingEntity)entity;
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeId));
                if (attribute == null || (attributeInstance = livingEntity.m_21051_(attribute)) == null) continue;
                attributeInstance.m_22100_(value);
            }
        }
        if (entity instanceof ItemEntity) {
            ItemStack itemStack;
            if (entity instanceof ItemEntity) {
                ItemEntity _itemEnt = (ItemEntity)entity;
                itemStack = _itemEnt.m_32055_();
            } else {
                itemStack = ItemStack.f_41583_;
            }
            ItemStack itemstack = itemStack;
            JsonObject itemVisionData = VisionHandler.getVisionData(itemstack);
            ItemStack replacementStack = VisionPropertyHandler.getDropReplacement(itemstack, itemVisionData);
            if (replacementStack != null && !replacementStack.m_41619_()) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                } else if (event.hasResult()) {
                    event.setResult(Event.Result.DENY);
                }
                Level world = entity.m_9236_();
                ItemEntity newItemEntity = new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), replacementStack);
                world.m_7967_((Entity)newItemEntity);
            } else if (VisionPropertyHandler.isBanned(itemstack, itemVisionData)) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                } else if (event.hasResult()) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
        if (!entity.getPersistentData().m_128471_("health_adjust")) {
            if (entity instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)entity;
                _entity.m_21153_((float)_entity.m_21051_(Attributes.f_22276_).m_22115_());
            }
            entity.getPersistentData().m_128379_("health_adjust", true);
        }
        if (visionData != null && visionData.has("variants")) {
            String chosenVariant = MobVariantHelper.setOrGetVariant(entity, visionData);
            serverLevel.m_7654_().execute(() -> VMinusMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobVariantSyncPacket(entity.m_19879_(), chosenVariant)));
            VMinusMod.queueServerWork(1, () -> serverLevel.m_7654_().execute(() -> VMinusMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobVariantSyncPacket(entity.m_19879_(), chosenVariant))));
        }
    }
}

