/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import net.lixir.vminus.registry.VMinusAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChangeAttackTargetEventHandler {
    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity targetEntity;
        LivingEntity sourceEntity;
        block6: {
            block5: {
                LivingEntity entity = event.getOriginalTarget();
                sourceEntity = event.getEntity();
                if (entity == null || sourceEntity == null) {
                    return;
                }
                if (!(entity instanceof LivingEntity)) break block5;
                targetEntity = entity;
                if (sourceEntity instanceof LivingEntity) break block6;
            }
            return;
        }
        LivingEntity attackerEntity = sourceEntity;
        double distance = targetEntity.m_20270_((Entity)attackerEntity);
        double trackingRange = ChangeAttackTargetEventHandler.getTrackingRange(attackerEntity);
        double hostileAttraction = ChangeAttackTargetEventHandler.getHostileAttractionValue(targetEntity);
        double cutoffRange = trackingRange - trackingRange * (hostileAttraction * -1.0 / 100.0);
        if (distance > cutoffRange && event != null && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private static double getTrackingRange(LivingEntity entity) {
        if (entity.m_21051_(Attributes.f_22277_) != null) {
            return entity.m_21051_(Attributes.f_22277_).m_22135_();
        }
        return 0.0;
    }

    private static double getHostileAttractionValue(LivingEntity entity) {
        if (entity.m_21051_((Attribute)VMinusAttributes.MOBDETECTIONRANGE.get()) != null) {
            return entity.m_21051_((Attribute)VMinusAttributes.MOBDETECTIONRANGE.get()).m_22115_();
        }
        return 0.0;
    }
}

