/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.blockset;

import java.util.Objects;
import javax.annotation.Nullable;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.registry.util.BlockSet;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockSetStateProvider
extends BlockStateProvider {
    private final String modId;

    public BlockSetStateProvider(PackOutput output, ExistingFileHelper exFileHelper, String modId) {
        super(output, modId, exFileHelper);
        this.modId = modId;
    }

    protected void registerStatesAndModels() {
        BlockSet.BLOCK_SETS.stream().filter(blockSet -> blockSet.getModId().equals(this.modId)).forEach(this::registerBlockSetStates);
    }

    private void registerBlockSetStates(BlockSet blockSet) {
        WallSignBlock wallSignBlock;
        StandingSignBlock standingSignBlock;
        String baseName = blockSet.getBaseName();
        ResourceLocation baseBlockKey = blockSet.isWoodSet() ? new ResourceLocation(this.modId, baseName + "_planks") : new ResourceLocation(this.modId, baseName);
        RegistryObject baseBlock = RegistryObject.create((ResourceLocation)baseBlockKey, (IForgeRegistry)ForgeRegistries.BLOCKS);
        String alternateBaseName = blockSet.getAlternateBaseNameRaw();
        BlockSet.RenderType renderType = blockSet.getRenderType();
        if (blockSet.hasBase()) {
            this.simpleBlockWithItem((Block)baseBlock.get(), this.cubeAll((Block)baseBlock.get()));
        }
        if (blockSet.hasStairs()) {
            this.registerStairsBlock(baseName, renderType, alternateBaseName);
        }
        if (blockSet.hasSlab()) {
            this.registerSlabBlock(baseName, renderType, alternateBaseName);
        }
        if (blockSet.hasWall()) {
            this.registerWallBlock(baseName, alternateBaseName);
        }
        if (blockSet.hasFence()) {
            this.registerFenceBlock(baseName, alternateBaseName);
        }
        if (blockSet.hasFenceGate()) {
            this.registerFenceGateBlock(baseName, alternateBaseName);
        }
        if (blockSet.hasPressurePlate()) {
            this.registerPressurePlateBlock(baseName, alternateBaseName);
        }
        if (blockSet.hasButton()) {
            this.registerButtonBlock(baseName, alternateBaseName);
        }
        if (blockSet.hasTrapdoor()) {
            this.registerTrapdoorBlock(baseName);
        }
        if (blockSet.hasDoor()) {
            this.registerDoorBlock(baseName);
        }
        if (blockSet.hasSign()) {
            standingSignBlock = (StandingSignBlock)blockSet.getStandingSignBlock();
            wallSignBlock = (WallSignBlock)blockSet.getWallSignBlock();
            this.registerSignBlock(standingSignBlock, wallSignBlock, baseName, (Block)baseBlock.get());
        }
        if (blockSet.hasHangingSign()) {
            standingSignBlock = blockSet.getHangingSignBlock();
            wallSignBlock = blockSet.getWallHangingSignBlock();
            this.registerHangingSignBlock((Block)standingSignBlock, (Block)wallSignBlock, baseName);
        }
        if (blockSet.hasLog()) {
            Block logBlock = blockSet.getLogBlock();
            Block strippedLogBlock = blockSet.getStrippedLogBlock();
            Block woodBlock = blockSet.getWoodBlock();
            Block strippedWoodBlock = blockSet.getStrippedWoodBlock();
            this.logBlock((RotatedPillarBlock)logBlock);
            this.axisBlock((RotatedPillarBlock)woodBlock, this.blockTexture(logBlock), this.blockTexture(logBlock));
            this.axisBlock((RotatedPillarBlock)strippedLogBlock, this.blockTexture(strippedLogBlock), new ResourceLocation(this.blockTexture(strippedLogBlock) + "_top"));
            this.axisBlock((RotatedPillarBlock)strippedWoodBlock, this.blockTexture(strippedLogBlock), this.blockTexture(strippedLogBlock));
            this.blockItem(logBlock);
            this.blockItem(woodBlock);
            this.blockItem(strippedLogBlock);
            this.blockItem(strippedWoodBlock);
        }
        if (blockSet.hasCracked()) {
            this.registerCrackedBlock(baseName);
        }
        if (blockSet.hasLeaves()) {
            Block leavesBlock = blockSet.getLeavesBlock();
            this.registerLeaves(leavesBlock);
        }
    }

    private void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.modId + ":block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_()));
    }

    private ResourceLocation getTextureLocation(String baseName, @Nullable String alternateBaseName) {
        String fixedAlternateBaseName;
        String alternateNamespace = BlockSet.getAlternateNamespace(alternateBaseName);
        ResourceLocation resourceLocation = alternateNamespace != null && !alternateNamespace.isEmpty() ? new ResourceLocation(alternateNamespace, "block/" + ((fixedAlternateBaseName = BlockSet.getAlternateBaseName(alternateBaseName)) != null ? fixedAlternateBaseName : baseName)) : this.modLoc("block/" + baseName);
        return resourceLocation;
    }

    private void registerWallBlock(String baseName, @Nullable String alternateBaseName) {
        String wallName = BlockSet.correctBaseName(baseName) + "_wall";
        ResourceLocation key = new ResourceLocation(this.modId, wallName);
        RegistryObject wallBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (wallBlock.isPresent()) {
            Block block = (Block)wallBlock.get();
            if (block instanceof WallBlock) {
                this.wallBlock(block, baseName, alternateBaseName);
                this.itemModels().wallInventory(wallName, this.getTextureLocation(baseName, alternateBaseName));
            } else {
                VMinusMod.LOGGER.warn("Wall block is not a WallBlock: {}", (Object)wallName);
            }
        } else {
            VMinusMod.LOGGER.warn("Wall block not found: {}", (Object)wallName);
        }
    }

    private void registerSlabBlock(String baseName, BlockSet.RenderType renderType, @Nullable String alternateBaseName) {
        String slabName = BlockSet.correctBaseName(baseName) + "_slab";
        ResourceLocation key = new ResourceLocation(this.modId, slabName);
        RegistryObject slabBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (slabBlock.isPresent()) {
            Block block = (Block)slabBlock.get();
            if (block instanceof SlabBlock) {
                this.slabBlock(baseName, renderType, alternateBaseName);
                this.itemModels().withExistingParent(slabName, this.modId + ":block/" + slabName);
            } else {
                VMinusMod.LOGGER.warn("BlockSet Slab block is not a SlabBlock: {}", (Object)slabName);
            }
        } else {
            VMinusMod.LOGGER.warn("BlockSet Slab block not found: {}", (Object)slabName);
        }
    }

    private void registerStairsBlock(String baseName, BlockSet.RenderType renderType, @Nullable String alternateBaseName) {
        String stairsName = BlockSet.correctBaseName(baseName) + "_stairs";
        ResourceLocation key = new ResourceLocation(this.modId, stairsName);
        RegistryObject stairsBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (stairsBlock.isPresent()) {
            Block block = (Block)stairsBlock.get();
            if (block instanceof StairBlock) {
                this.stairsBlock(block, baseName, renderType, alternateBaseName);
                this.itemModels().withExistingParent(stairsName, this.modId + "block/" + stairsName);
            } else {
                VMinusMod.LOGGER.warn("Stairs block is not a StairBlock: {}", (Object)stairsName);
            }
        } else {
            VMinusMod.LOGGER.warn("Stairs block not found: {}", (Object)stairsName);
        }
    }

    private void registerFenceBlock(String baseName, @Nullable String alternateBaseName) {
        String fenceName = BlockSet.correctBaseName(baseName) + "_fence";
        ResourceLocation key = new ResourceLocation(this.modId, fenceName);
        RegistryObject fenceBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (fenceBlock.isPresent()) {
            Block block = (Block)fenceBlock.get();
            if (block instanceof FenceBlock) {
                this.fenceBlock(block, baseName, alternateBaseName);
                this.itemModels().fenceInventory(fenceName, this.getTextureLocation(baseName, alternateBaseName));
            } else {
                VMinusMod.LOGGER.warn("Fence block is not a FenceBlock: {}", (Object)fenceName);
            }
        } else {
            VMinusMod.LOGGER.warn("Fence block not found: {}", (Object)fenceName);
        }
    }

    private void registerFenceGateBlock(String baseName, @Nullable String alternateBaseName) {
        String fenceGateName = BlockSet.correctBaseName(baseName) + "_fence_gate";
        ResourceLocation key = new ResourceLocation(this.modId, fenceGateName);
        RegistryObject fenceGateBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (fenceGateBlock.isPresent()) {
            Block block = (Block)fenceGateBlock.get();
            if (block instanceof FenceGateBlock) {
                this.fenceGateBlock(block, baseName, alternateBaseName);
                this.itemModels().withExistingParent(fenceGateName, this.modId + "block/" + fenceGateName);
            } else {
                VMinusMod.LOGGER.warn("Fence gate block is not a FenceGateBlock: {}", (Object)fenceGateName);
            }
        } else {
            VMinusMod.LOGGER.warn("Fence gate block not found: {}", (Object)fenceGateName);
        }
    }

    private void registerPressurePlateBlock(String baseName, @Nullable String alternateBaseName) {
        String pressurePlateName = BlockSet.correctBaseName(baseName) + "_pressure_plate";
        ResourceLocation key = new ResourceLocation(this.modId, pressurePlateName);
        RegistryObject pressurePlateBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (pressurePlateBlock.isPresent()) {
            Block block = (Block)pressurePlateBlock.get();
            if (block instanceof PressurePlateBlock) {
                this.pressurePlateBlock(block, baseName, alternateBaseName);
                this.itemModels().withExistingParent(pressurePlateName, this.modId + "block/" + pressurePlateName);
            } else {
                VMinusMod.LOGGER.warn("Pressure plate block is not a PressurePlateBlock: {}", (Object)pressurePlateName);
            }
        } else {
            VMinusMod.LOGGER.warn("Pressure plate block not found: {}", (Object)pressurePlateName);
        }
    }

    private void registerButtonBlock(String baseName, @Nullable String alternateBaseName) {
        String buttonName = BlockSet.correctBaseName(baseName) + "_button";
        ResourceLocation key = new ResourceLocation(this.modId, buttonName);
        RegistryObject buttonBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (buttonBlock.isPresent()) {
            Block block = (Block)buttonBlock.get();
            if (block instanceof ButtonBlock) {
                this.buttonBlock(block, baseName, alternateBaseName);
                this.itemModels().buttonInventory(buttonName, this.getTextureLocation(baseName, alternateBaseName));
            } else {
                VMinusMod.LOGGER.warn("Button block is not a ButtonBlock: {}", (Object)buttonName);
            }
        } else {
            VMinusMod.LOGGER.warn("Button block not found: {}", (Object)buttonName);
        }
    }

    private void registerTrapdoorBlock(String baseName) {
        String trapdoorName = BlockSet.correctBaseName(baseName) + "_trapdoor";
        ResourceLocation key = new ResourceLocation(this.modId, trapdoorName);
        RegistryObject trapdoorBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        Block block = (Block)trapdoorBlock.get();
        ResourceLocation trapdoorTexture = new ResourceLocation(this.modId, "block/" + trapdoorName);
        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, trapdoorTexture, true, "cutout");
        this.itemModels().trapdoorBottom(trapdoorName, trapdoorTexture);
    }

    private void registerDoorBlock(String baseName) {
        String doorName = BlockSet.correctBaseName(baseName) + "_door";
        ResourceLocation key = new ResourceLocation(this.modId, doorName);
        RegistryObject doorBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (doorBlock.isPresent()) {
            Block block = (Block)doorBlock.get();
            if (block instanceof DoorBlock) {
                this.doorBlock(block, doorName);
                this.itemModels().basicItem(new ResourceLocation(this.modId, doorName));
            } else {
                VMinusMod.LOGGER.warn("Door block is not a DoorBlock: {}", (Object)doorName);
            }
        } else {
            VMinusMod.LOGGER.warn("Door block not found: {}", (Object)doorName);
        }
    }

    private void registerSignBlock(StandingSignBlock standingSignBlock, WallSignBlock wallSignBlock, String baseName, Block block) {
        String standingSignName = BlockSet.correctBaseName(baseName) + "_sign";
        this.signBlock(standingSignBlock, wallSignBlock, this.blockTexture(block));
        this.itemModels().basicItem(new ResourceLocation(this.modId, standingSignName));
    }

    private void registerHangingSignBlock(Block signBlock, Block wallSignBlock, String baseName) {
        String correctBaseName = BlockSet.correctBaseName(baseName);
        String hangingSignName = correctBaseName + "_hanging_sign";
        ModelBuilder sign = this.models().sign(this.name(signBlock), new ResourceLocation(this.modId, "entity/signs/hanging/" + correctBaseName));
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
        this.itemModels().basicItem(new ResourceLocation(this.modId, hangingSignName));
    }

    private void registerLeaves(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().singleTexture(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture(block)));
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void registerCrackedBlock(String baseName) {
        String crackedName = "cracked_" + baseName;
        ResourceLocation key = new ResourceLocation(this.modId, crackedName);
        RegistryObject crackedBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (crackedBlock.isPresent()) {
            this.simpleBlockWithItem((Block)crackedBlock.get(), this.cubeAll((Block)crackedBlock.get()));
        } else {
            VMinusMod.LOGGER.warn("Cracked block not found: {}", (Object)crackedName);
        }
    }

    private void wallBlock(Block block, String baseName, @Nullable String alternateBaseName) {
        this.wallBlock((WallBlock)block, this.getTextureLocation(baseName, alternateBaseName));
    }

    private void fenceBlock(Block block, String baseName, @Nullable String alternateBaseName) {
        this.fenceBlock((FenceBlock)block, baseName, this.getTextureLocation(baseName, alternateBaseName));
    }

    private void fenceGateBlock(Block block, String baseName, @Nullable String alternateBaseName) {
        this.fenceGateBlock((FenceGateBlock)block, baseName, this.getTextureLocation(baseName, alternateBaseName));
    }

    private void buttonBlock(Block block, String baseName, @Nullable String alternateBaseName) {
        this.buttonBlock((ButtonBlock)block, this.getTextureLocation(baseName, alternateBaseName));
    }

    private void pressurePlateBlock(Block block, String baseName, @Nullable String alternateBaseName) {
        this.pressurePlateBlock((PressurePlateBlock)block, this.getTextureLocation(baseName, alternateBaseName));
    }

    private void doorBlock(Block block, String doorName) {
        ResourceLocation bottomLocation = new ResourceLocation(this.modId, "block/" + doorName + "_bottom");
        ResourceLocation topLocation = new ResourceLocation(this.modId, "block/" + doorName + "_top");
        this.doorBlockWithRenderType((DoorBlock)block, bottomLocation, topLocation, "cutout_mipped");
    }

    private void slabBlock(String baseName, BlockSet.RenderType renderType, @Nullable String alternateBaseName) {
        String slabName = BlockSet.correctBaseName(baseName) + "_slab";
        ResourceLocation key = new ResourceLocation(this.modId, slabName);
        RegistryObject slabBlock = RegistryObject.create((ResourceLocation)key, (IForgeRegistry)ForgeRegistries.BLOCKS);
        if (slabBlock.isPresent()) {
            Block blockInstance = (Block)slabBlock.get();
            if (blockInstance instanceof SlabBlock) {
                if (!renderType.equals((Object)BlockSet.RenderType.NORMAL)) {
                    this.slabBlockWithRenderType((SlabBlock)blockInstance, this.getTextureLocation(baseName, alternateBaseName), renderType);
                } else {
                    this.slabBlock((SlabBlock)blockInstance, this.getTextureLocation(baseName, alternateBaseName), this.getTextureLocation(baseName, alternateBaseName));
                }
            } else {
                VMinusMod.LOGGER.warn("Slab block is not a SlabBlock: {}", (Object)slabName);
            }
        } else {
            VMinusMod.LOGGER.warn("Slab block not found: {}", (Object)slabName);
        }
    }

    private void slabBlockWithRenderType(SlabBlock block, ResourceLocation texture, BlockSet.RenderType renderType) {
        String renderTypeString = BlockSet.renderTypeToString(renderType);
        this.getVariantBuilder((Block)block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().slab(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_(), texture, texture, texture)).renderType(renderTypeString))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().slabTop(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_top", texture, texture, texture)).renderType(renderTypeString))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cubeAll(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_double", texture)).renderType(renderTypeString))});
    }

    private void stairsBlock(Block block, String baseName, BlockSet.RenderType renderType, @Nullable String alternateBaseName) {
        this.stairsBlockWithRenderType((StairBlock)block, this.getTextureLocation(baseName, alternateBaseName), BlockSet.renderTypeToString(renderType));
    }

    public void simpleBlockWithItem(Block block, ModelFile model) {
        this.simpleBlock(block, model);
        ((ItemModelBuilder)this.itemModels().getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_())).parent(model);
    }
}

