/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DurabilityCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"durability").requires(s -> s.m_6761_(3))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"operation", (ArgumentType)StringArgumentType.word()).suggests(DurabilityCommand::getOperationSuggestions).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(arguments -> {
            DurabilityCommand.handleDurabilityCommand((CommandContext<CommandSourceStack>)arguments);
            return 0;
        })))));
    }

    private static void handleDurabilityCommand(CommandContext<CommandSourceStack> arguments) {
        try {
            block12: for (Entity entity : EntityArgument.m_91461_(arguments, (String)"entities")) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack mainhand = livingEntity.m_21205_();
                String operation = StringArgumentType.getString(arguments, (String)"operation");
                double amount = DoubleArgumentType.getDouble(arguments, (String)"amount");
                switch (operation) {
                    case "set": {
                        mainhand.m_41721_((int)Math.max(0.0, (double)mainhand.m_41776_() - amount));
                        continue block12;
                    }
                    case "decrease": {
                        mainhand.m_41721_((int)Math.max((double)mainhand.m_41773_() + amount, 0.0));
                        continue block12;
                    }
                    case "increase": {
                        mainhand.m_41721_((int)Math.min((double)mainhand.m_41773_() - amount, (double)mainhand.m_41776_()));
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Invalid operation: " + operation);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }

    private static CompletableFuture<Suggestions> getOperationSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        builder.suggest("set");
        builder.suggest("increase");
        builder.suggest("decrease");
        return builder.buildFuture();
    }
}

