/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.capes;

import net.minecraft.resources.ResourceLocation;

public enum Cape {
    BEEPER("beeper", "vminus", "textures/cape/beeper.png"),
    GHOST("ghost", "vminus", "textures/cape/ghost.png"),
    SHROUD("shroud", "vminus", "textures/cape/shroud.png"),
    MARROW("marrow", "vminus", "textures/cape/marrow.png"),
    PROTOTYPE("prototype", "vminus", "textures/cape/prototype.png"),
    TROLL("troll", "vminus", "textures/cape/troll.png"),
    PHOTON("photon", "vminus", "textures/cape/photon.png");

    private final String id;
    private final String namespace;
    private final String texturePath;

    private Cape(String id, String namespace, String texturePath) {
        this.id = id;
        this.namespace = namespace;
        this.texturePath = texturePath;
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation(this.namespace, this.texturePath);
    }

    public static Cape fromString(String capeId) {
        for (Cape id : Cape.values()) {
            if (!id.getId().equalsIgnoreCase(capeId)) continue;
            return id;
        }
        return null;
    }

    public static Cape fromId(String capeId) {
        for (Cape id : Cape.values()) {
            if (!id.getId().equalsIgnoreCase(capeId)) continue;
            return id;
        }
        return null;
    }
}

