/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.block;

import net.lixir.vminus.block.StainedGlassStairsBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class StainedGlassSlabBlock
extends SlabBlock
implements BeaconBeamBlock {
    private final DyeColor color;

    public StainedGlassSlabBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        Block blockFrom = stateFrom.m_60734_();
        if (blockFrom instanceof StainedGlassBlock && ((StainedGlassBlock)blockFrom).m_7988_() == this.color) {
            return true;
        }
        if (blockFrom == this && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (blockFrom instanceof StainedGlassStairsBlock && ((StainedGlassStairsBlock)blockFrom).m_7988_() == this.color && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        switch (direction) {
            case UP: {
                if (typeFrom == SlabType.TOP || type == SlabType.BOTTOM) break;
                return true;
            }
            case DOWN: {
                if (typeFrom == SlabType.BOTTOM || type == SlabType.TOP) break;
                return true;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                if (type != typeFrom && typeFrom != SlabType.DOUBLE) break;
                return true;
            }
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        if (direction == Direction.UP && halfFrom == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && halfFrom == Half.TOP) {
            return true;
        }
        if (facingFrom == direction.m_122424_()) {
            return true;
        }
        if (direction.m_122416_() != -1) {
            if (type == SlabType.BOTTOM && halfFrom == Half.BOTTOM) {
                return true;
            }
            if (type == SlabType.TOP && halfFrom == Half.TOP) {
                return true;
            }
        }
        return false;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public DyeColor m_7988_() {
        return this.color;
    }
}

