/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.block;

import java.util.function.Supplier;
import net.lixir.vminus.block.GlassSlabBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassStairsBlock
extends StairBlock {
    public GlassStairsBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(state, properties);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        Block blockFrom = stateFrom.m_60734_();
        if (blockFrom == Blocks.f_50058_) {
            return true;
        }
        if (blockFrom instanceof GlassSlabBlock) {
            return this.isInvisibleToGlassSlab(state, stateFrom, direction);
        }
        if (blockFrom == this) {
            return this.isInvisibleToGlassStairs(state, stateFrom, direction);
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        switch (direction) {
            case UP: {
                return typeFrom != SlabType.TOP;
            }
            case DOWN: {
                return typeFrom != SlabType.BOTTOM;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                if (direction == facing.m_122424_()) {
                    return this.checkFront(typeFrom, half);
                }
                if (direction == facing.m_122427_() && shape == StairsShape.OUTER_LEFT) {
                    return this.checkRight(typeFrom, half);
                }
                if (direction != facing.m_122428_() || shape != StairsShape.OUTER_RIGHT) break;
                return this.checkLeft(typeFrom, half);
            }
        }
        return false;
    }

    private boolean checkFront(SlabType typeFrom, Half half) {
        return typeFrom == SlabType.BOTTOM && half == Half.BOTTOM || typeFrom == SlabType.TOP && half == Half.TOP;
    }

    private boolean checkRight(SlabType typeFrom, Half half) {
        return typeFrom == SlabType.BOTTOM && half == Half.BOTTOM || typeFrom == SlabType.TOP && half == Half.TOP;
    }

    private boolean checkLeft(SlabType typeFrom, Half half) {
        return typeFrom == SlabType.BOTTOM && half == Half.BOTTOM || typeFrom == SlabType.TOP && half == Half.TOP;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        StairsShape shapeFrom = (StairsShape)stateFrom.m_61143_((Property)StairBlock.f_56843_);
        if (direction == Direction.UP) {
            return this.checkUp(half, halfFrom, facing, facingFrom, shape, shapeFrom);
        }
        if (direction == Direction.DOWN) {
            return this.checkDown(half, halfFrom, facing, facingFrom, shape, shapeFrom);
        }
        if (facing == facingFrom && (direction == facing.m_122428_() || direction == facing.m_122427_())) {
            return shape == shapeFrom || shape == StairsShape.STRAIGHT && shapeFrom == StairsShape.STRAIGHT;
        }
        if (facingFrom == direction.m_122424_()) {
            return shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT;
        }
        return this.checkCurvedSides(facingFrom, direction, shapeFrom);
    }

    private boolean checkUp(Half half, Half halfFrom, Direction facing, Direction facingFrom, StairsShape shape, StairsShape shapeFrom) {
        if (halfFrom == Half.BOTTOM) {
            return true;
        }
        if (half != halfFrom) {
            if (facing == facingFrom && shape == shapeFrom) {
                return true;
            }
            return this.checkShapeCompatibility(shape, shapeFrom, facing, facingFrom);
        }
        return false;
    }

    private boolean checkDown(Half half, Half halfFrom, Direction facing, Direction facingFrom, StairsShape shape, StairsShape shapeFrom) {
        if (halfFrom == Half.TOP) {
            return true;
        }
        return this.checkShapeCompatibility(shape, shapeFrom, facing, facingFrom);
    }

    private boolean checkShapeCompatibility(StairsShape shape, StairsShape shapeFrom, Direction facing, Direction facingFrom) {
        switch (shape) {
            case STRAIGHT: {
                return this.isStraightCompatible(shapeFrom, facing, facingFrom);
            }
            case INNER_LEFT: {
                return shapeFrom == StairsShape.INNER_RIGHT && facingFrom == facing.m_122428_();
            }
            case INNER_RIGHT: {
                return shapeFrom == StairsShape.INNER_LEFT && facingFrom == facing.m_122427_();
            }
            case OUTER_LEFT: {
                return this.isOuterLeftCompatible(shapeFrom, facing, facingFrom);
            }
            case OUTER_RIGHT: {
                return this.isOuterRightCompatible(shapeFrom, facing, facingFrom);
            }
        }
        return false;
    }

    private boolean isStraightCompatible(StairsShape shapeFrom, Direction facing, Direction facingFrom) {
        return shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.m_122427_()) || shapeFrom == StairsShape.INNER_RIGHT && (facingFrom == facing || facingFrom == facing.m_122428_());
    }

    private boolean isOuterLeftCompatible(StairsShape shapeFrom, Direction facing, Direction facingFrom) {
        if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.m_122428_()) {
            return true;
        }
        if (shapeFrom == StairsShape.STRAIGHT || facingFrom == facing) {
            return true;
        }
        return shapeFrom == StairsShape.INNER_RIGHT && facingFrom == facing.m_122428_();
    }

    private boolean isOuterRightCompatible(StairsShape shapeFrom, Direction facing, Direction facingFrom) {
        if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.m_122427_()) {
            return true;
        }
        if (shapeFrom == StairsShape.STRAIGHT || facingFrom == facing) {
            return true;
        }
        return shapeFrom == StairsShape.INNER_LEFT && facingFrom == facing.m_122427_();
    }

    private boolean checkCurvedSides(Direction facingFrom, Direction direction, StairsShape shapeFrom) {
        if (shapeFrom == StairsShape.INNER_RIGHT && facingFrom.m_122428_() == direction) {
            return true;
        }
        if (shapeFrom == StairsShape.INNER_LEFT && facingFrom.m_122427_() == direction) {
            return true;
        }
        if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom.m_122427_() == direction) {
            return true;
        }
        return shapeFrom == StairsShape.OUTER_RIGHT && facingFrom.m_122428_() == direction;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }
}

