/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.block;

import net.lixir.vminus.block.GlassStairsBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassSlabBlock
extends SlabBlock {
    public GlassSlabBlock(BlockBehaviour.Properties p_56359_) {
        super(p_56359_);
    }

    public boolean m_6104_(BlockState currentState, BlockState neighborState, Direction direction) {
        Block neighborBlock = neighborState.m_60734_();
        if (neighborBlock == Blocks.f_50058_) {
            return true;
        }
        if (neighborBlock == this && this.isInvisibleToGlassSlab(currentState, neighborState, direction)) {
            return true;
        }
        if (neighborBlock instanceof GlassStairsBlock && this.isInvisibleToGlassStairs(currentState, neighborState, direction)) {
            return true;
        }
        return super.m_6104_(currentState, neighborState, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState currentState, BlockState neighborState, Direction direction) {
        SlabType currentSlabType = (SlabType)currentState.m_61143_((Property)SlabBlock.f_56353_);
        SlabType neighborSlabType = (SlabType)neighborState.m_61143_((Property)SlabBlock.f_56353_);
        switch (direction) {
            case UP: {
                return neighborSlabType != SlabType.TOP && currentSlabType != SlabType.BOTTOM;
            }
            case DOWN: {
                return neighborSlabType != SlabType.BOTTOM && currentSlabType != SlabType.TOP;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                return currentSlabType == neighborSlabType || neighborSlabType == SlabType.DOUBLE;
            }
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState currentState, BlockState neighborState, Direction direction) {
        SlabType currentSlabType = (SlabType)currentState.m_61143_((Property)SlabBlock.f_56353_);
        Half neighborHalf = (Half)neighborState.m_61143_((Property)StairBlock.f_56842_);
        Direction neighborFacing = (Direction)neighborState.m_61143_((Property)StairBlock.f_56841_);
        if (direction == Direction.UP && neighborHalf == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && neighborHalf == Half.TOP) {
            return true;
        }
        if (neighborFacing == direction.m_122424_()) {
            return true;
        }
        return direction.m_122416_() != -1 && (currentSlabType == SlabType.BOTTOM && neighborHalf == Half.BOTTOM || currentSlabType == SlabType.TOP && neighborHalf == Half.TOP);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }
}

