/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundHelper {
    public static SoundType CreateBlockSoundType(@Nullable String breakSound, @Nullable String stepSound, @Nullable String placeSound, @Nullable String hitSound, @Nullable String fallSound) {
        if (breakSound == null || breakSound.isEmpty()) {
            breakSound = "minecraft:block.stone.break";
        }
        if (stepSound == null || stepSound.isEmpty()) {
            stepSound = "minecraft:block.stone.step";
        }
        if (placeSound == null || placeSound.isEmpty()) {
            placeSound = "minecraft:block.stone.place";
        }
        if (hitSound == null || hitSound.isEmpty()) {
            hitSound = "minecraft:block.stone.hit";
        }
        if (fallSound == null || fallSound.isEmpty()) {
            fallSound = "minecraft:block.stone.fall";
        }
        SoundEvent breakEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(breakSound));
        SoundEvent stepEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(stepSound));
        SoundEvent placeEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(placeSound));
        SoundEvent hitEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(hitSound));
        SoundEvent fallEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(fallSound));
        return new SoundType(1.0f, 1.0f, breakEvent, stepEvent, placeEvent, hitEvent, fallEvent);
    }

    @Nullable
    public static SoundEvent getSoundEventFromString(String soundName) {
        ResourceLocation soundLocation = new ResourceLocation(soundName);
        if (ForgeRegistries.SOUND_EVENTS.containsKey(soundLocation)) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
        }
        return null;
    }
}

