/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.advancements;

import com.google.common.collect.Maps;
import com.hlysine.create_connected.CreateConnected;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CriterionTriggerBase<T extends Instance>
implements CriterionTrigger<T> {
    private final ResourceLocation id;
    protected final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<T>>> listeners = Maps.newHashMap();

    public CriterionTriggerBase(String id) {
        this.id = CreateConnected.asResource(id);
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<T> listener) {
        Set playerListeners = this.listeners.computeIfAbsent(playerAdvancementsIn, k -> new HashSet());
        playerListeners.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<T> listener) {
        Set<CriterionTrigger.Listener<T>> playerListeners = this.listeners.get(playerAdvancementsIn);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    protected void trigger(ServerPlayer player, @Nullable List<Supplier<Object>> suppliers) {
        PlayerAdvancements playerAdvancements = player.m_8960_();
        Set<CriterionTrigger.Listener<T>> playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            LinkedList<CriterionTrigger.Listener<T>> list = new LinkedList<CriterionTrigger.Listener<T>>();
            for (CriterionTrigger.Listener<T> listener2 : playerListeners) {
                if (!((Instance)listener2.m_13685_()).test(suppliers)) continue;
                list.add(listener2);
            }
            list.forEach(listener -> listener.m_13686_(playerAdvancements));
        }
    }

    public static abstract class Instance
    extends AbstractCriterionTriggerInstance {
        public Instance(ResourceLocation idIn, ContextAwarePredicate predicate) {
            super(idIn, predicate);
        }

        protected abstract boolean test(@Nullable List<Supplier<Object>> var1);
    }
}

