/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.CCPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class KineticBridgeVisual
extends KineticBlockEntityVisual<KineticBlockEntity> {
    protected final RotatingInstance shaft;
    protected final RotatingInstance coupling;
    final Direction direction;
    private final Direction opposite;

    public KineticBridgeVisual(VisualizationContext context, KineticBlockEntity blockEntity, float partialTick, boolean isDestination) {
        super(context, blockEntity, partialTick);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        if (isDestination) {
            facing = facing.m_122424_();
        }
        this.direction = facing;
        this.opposite = this.direction.m_122424_();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
        this.coupling = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)(isDestination ? CCPartialModels.KINETIC_BRIDGE_DESTINATION : CCPartialModels.KINETIC_BRIDGE_SOURCE))).createInstance();
        this.shaft.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.coupling.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
    }

    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        this.coupling.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        BlockPos behind = this.pos.m_121945_(this.opposite);
        this.relight(behind, new FlatLit[]{this.shaft});
        BlockPos inFront = this.pos.m_121945_(this.direction);
        this.relight(inFront, new FlatLit[]{this.coupling});
    }

    protected void _delete() {
        this.shaft.delete();
        this.coupling.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.coupling);
    }
}

