/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.capuchin;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AncientDartPotion;
import com.github.alexthe666.alexsmobs.entity.EntityTossedItem;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityTossedItem.class})
public abstract class AMITossedItemMixin
extends ThrowableItemProjectile
implements AncientDartPotion {
    private static final EntityDataAccessor<Integer> POTION_LEVEL = SynchedEntityData.m_135353_(EntityTossedItem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> APPLIED_POTION = SynchedEntityData.m_135353_(EntityTossedItem.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final Object2IntMap<String> potionToColor = new Object2IntOpenHashMap();

    @Shadow
    public abstract boolean isDart();

    public AMITossedItemMixin(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected Item m_7881_() {
        return this.isDart() ? (Item)AMItemRegistry.ANCIENT_DART.get() : ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GOOFY_CAPUCHIN_BOMB_ENABLED.get() != false ? Items.f_41996_ : Items.f_42594_);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(APPLIED_POTION, (Object)"");
        this.f_19804_.m_135372_(POTION_LEVEL, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128359_("PotionName", this.getPotionId());
        compound.m_128405_("PotionLevel", this.getPotionLevel());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setPotionId(compound.m_128461_("PotionName"));
        this.setPotionLevel(compound.m_128451_("PotionLevel"));
    }

    @Override
    public String getPotionId() {
        return (String)this.f_19804_.m_135370_(APPLIED_POTION);
    }

    @Override
    public void setPotionId(String potionId) {
        this.f_19804_.m_135381_(APPLIED_POTION, (Object)potionId);
    }

    public int getPotionLevel() {
        return (Integer)this.f_19804_.m_135370_(POTION_LEVEL);
    }

    @Override
    public void setPotionLevel(int time) {
        this.f_19804_.m_135381_(POTION_LEVEL, (Object)time);
    }

    @Override
    public int getPotionColor() {
        String id = this.getPotionId();
        if (id.isEmpty()) {
            return -1;
        }
        if (!potionToColor.containsKey((Object)id)) {
            MobEffect effect = this.getPotionEffect();
            if (effect != null) {
                int color = effect.m_19484_();
                potionToColor.put((Object)id, color);
                return color;
            }
            return -1;
        }
        return potionToColor.getInt((Object)id);
    }

    public MobEffect getPotionEffect() {
        if (this.getPotionId() != null) {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.getPotionId()));
        }
        return null;
    }

    @Inject(method={"onHit"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$onHit(HitResult result, CallbackInfo ci) {
        int x = this.m_146903_();
        int y = this.m_146904_();
        int z = this.m_146907_();
        if (!this.isDart() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GOOFY_CAPUCHIN_BOMB_ENABLED.get()).booleanValue()) {
            this.m_9236_().m_254849_((Entity)this, (double)(x + 1), (double)(y + 2), (double)(z + 1), 2.0f, Level.ExplosionInteraction.MOB);
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private void alexsMobsInteraction$onHitEntity(EntityHitResult p_213868_1_, CallbackInfo ci) {
        Entity entity;
        MobEffect potion = this.getPotionEffect();
        if (potion != null && (entity = p_213868_1_.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ANCIENT_EFFECTS_ENABLED.get()).booleanValue()) {
                MobEffectInstance instance = new MobEffectInstance(potion, 100, this.getPotionLevel());
                livingEntity.m_7292_(instance);
            }
        }
    }
}

