/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.capuchin;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.datagen.tags.AMIEntityTagGenerator;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AncientDartPotion;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import com.github.alexthe666.alexsmobs.entity.EntityTossedItem;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCapuchinMonkey.class})
public abstract class AMICapuchinMixin
extends TamableAnimal
implements AncientDartPotion {
    private static final EntityDataAccessor<Integer> DART_POTION_LEVEL = SynchedEntityData.m_135353_(EntityCapuchinMonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DART_POTION = SynchedEntityData.m_135353_(EntityCapuchinMonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final Object2IntMap<String> potionToColor = new Object2IntOpenHashMap();

    protected AMICapuchinMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract boolean hasDart();

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$registerGoals(CallbackInfo ci) {
        final EntityCapuchinMonkey capuchinMonkey = (EntityCapuchinMonkey)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ADD_TARGETS_ENABLED.get()).booleanValue()) {
            capuchinMonkey.f_21346_.m_25352_(4, (Goal)new EntityAINearestTarget3D<LivingEntity>((Mob)capuchinMonkey, LivingEntity.class, 400, true, true, AMEntityRegistry.buildPredicateFromTag(AMIEntityTagGenerator.INSECTS)){

                public boolean m_8045_() {
                    return super.m_8045_() && !capuchinMonkey.m_21824_();
                }
            });
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/github/alexthe666/alexsmobs/entity/EntityTossedItem;shoot(DDDFF)V")})
    private void alexsMobsInteraction$tick(CallbackInfo ci, @Local EntityTossedItem tossedItem) {
        if (!Objects.equals(this.getPotionId(), "")) {
            ((AncientDartPotion)tossedItem).setPotionId(this.getPotionId());
        }
    }

    @Inject(method={"onGetItem"}, at={@At(value="TAIL")}, remap=false)
    private void alexsMobsInteraction$onGetItem(ItemEntity e, CallbackInfo ci) {
        if (e.m_32055_().m_41614_() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FOOD_TARGET_EFFECTS_ENABLED.get()).booleanValue()) {
            this.m_5634_(5.0f);
            List test = Objects.requireNonNull(e.m_32055_().getFoodProperties((LivingEntity)this)).m_38749_();
            if (!test.isEmpty()) {
                for (int i = 0; i < test.size(); ++i) {
                    this.m_7292_(new MobEffectInstance((MobEffectInstance)((Pair)test.get(i)).getFirst()));
                }
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void alexsMobsInteraction$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Potion contained;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() instanceof PotionItem && this.hasDart() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FOOD_TARGET_EFFECTS_ENABLED.get()).booleanValue() && this.applyPotion(contained = PotionUtils.m_43579_((ItemStack)itemStack))) {
            this.m_146850_(GameEvent.f_223708_);
            this.m_216990_(SoundEvents.f_11769_);
            this.m_142075_(player, hand, itemStack);
            ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
            if (!player.m_36356_(bottle)) {
                player.m_36176_(bottle, false);
            }
            player.m_6674_(hand);
            AMIUtils.awardAdvancement((Entity)player, "dart_effect", "dart_effect");
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lcom/github/alexthe666/alexsmobs/entity/EntityCapuchinMonkey;setDart(Z)V", ordinal=1)})
    private void alexsMobsInteraction$mobInteract2(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        this.resetPotion();
    }

    public void resetPotion() {
        this.setPotionId("");
        this.setPotionLevel(0);
    }

    public boolean applyPotion(Potion potion) {
        MobEffectInstance fx;
        ResourceLocation potionId;
        if (potion == null || potion == Potions.f_43599_) {
            this.resetPotion();
            return true;
        }
        if (!potion.m_43488_().isEmpty() && (potionId = ForgeRegistries.MOB_EFFECTS.getKey((Object)(fx = (MobEffectInstance)potion.m_43488_().get(0)).m_19544_())) != null) {
            this.setPotionId(potionId.toString());
            this.setPotionLevel(fx.m_19564_());
            return true;
        }
        return false;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DART_POTION, (Object)"");
        this.f_19804_.m_135372_(DART_POTION_LEVEL, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128359_("PotionName", this.getPotionId());
        compound.m_128405_("PotionLevel", this.getPotionLevel());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setPotionId(compound.m_128461_("PotionName"));
        this.setPotionLevel(compound.m_128451_("PotionLevel"));
    }

    @Override
    public String getPotionId() {
        return (String)this.f_19804_.m_135370_(DART_POTION);
    }

    @Override
    public void setPotionId(String potionId) {
        this.f_19804_.m_135381_(DART_POTION, (Object)potionId);
    }

    public int getPotionLevel() {
        return (Integer)this.f_19804_.m_135370_(DART_POTION_LEVEL);
    }

    @Override
    public void setPotionLevel(int time) {
        this.f_19804_.m_135381_(DART_POTION_LEVEL, (Object)time);
    }

    public MobEffect getPotionEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.getPotionId()));
    }

    @Override
    public int getPotionColor() {
        String id = this.getPotionId();
        if (id.isEmpty()) {
            return -1;
        }
        if (!potionToColor.containsKey((Object)id)) {
            MobEffect effect = this.getPotionEffect();
            if (effect != null) {
                int color = effect.m_19484_();
                potionToColor.put((Object)id, color);
                return color;
            }
            return -1;
        }
        return potionToColor.getInt((Object)id);
    }
}

