/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.external_mobs.vanilla.player;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AMIBaseInterfaces;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.FarseerFx;
import com.crimsoncrips.alexsmobsinteraction.networking.AMIPacketHandler;
import com.crimsoncrips.alexsmobsinteraction.networking.AlterPacket;
import com.crimsoncrips.alexsmobsinteraction.server.enchantment.AMIEnchantmentRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAlligatorSnappingTurtle;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.util.RockyChestplateUtil;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class AMIPlayerMixin
extends LivingEntity
implements FarseerFx {
    private static final EntityDataAccessor<Integer> FARSEER_ALTERRING_TIME = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> FARSEER_STALKING_TIME = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> FARSEER_STALKING_DELAY = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected AMIPlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_203441_(FluidState pFluidState) {
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ROLLING_THUNDER_ENABLED.get()).booleanValue() && this.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)AMItemRegistry.ROCKY_CHESTPLATE.get())) {
            BlockState blockState = this.m_20075_();
            double z = this.m_20154_().f_82481_;
            double x = this.m_20154_().f_82479_;
            if (RockyChestplateUtil.isRockyRolling((LivingEntity)this) && this.m_9236_().m_6425_(this.m_20097_()).getFluidType() != null) {
                double d1 = this.m_217043_().m_188583_() * 0.01;
                BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                if (this.f_19796_.m_188500_() < 0.1) {
                    this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20208_(0.1), this.m_20186_() + 0.5, this.m_20262_(0.1), x * -2.0 * (double)this.m_217043_().m_188503_(2), 0.1 + d1, z * -2.0 * (double)this.m_217043_().m_188503_(2));
                }
                if (this.f_19796_.m_188500_() < 0.001) {
                    this.m_6844_(EquipmentSlot.CHEST).m_41622_(2, (LivingEntity)this, p_233654_0_ -> {});
                }
                AMIUtils.awardAdvancement((Entity)this, "rolling_thunder", "roll");
                return this.m_6844_(EquipmentSlot.CHEST).getEnchantmentLevel((Enchantment)AMIEnchantmentRegistry.ROLLING_THUNDER.get()) > 0;
            }
            return false;
        }
        return false;
    }

    @ModifyReturnValue(method={"isInvulnerableTo"}, at={@At(value="RETURN")})
    private boolean alexsMobsInteraction$isInvulnerableTo(boolean original, @Local DamageSource pSource) {
        return original || pSource.m_276093_(DamageTypes.f_268724_) && this.m_20202_() instanceof EntityEndergrade && (Boolean)AlexsMobsInteraction.COMMON_CONFIG.VOIDED_ENDERGRADE_ENABLED.get() != false;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void alexsMobsInteraction$tick(CallbackInfo ci) {
        EntityAlligatorSnappingTurtle snappingTurtle;
        Entity lookAt;
        Player player = (Player)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FARSEER_ALTERING_ENABLED.get()).booleanValue()) {
            if (this.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel((Enchantment)AMIEnchantmentRegistry.STABILIZER.get()) <= 0 && (double)this.getStalkTime() >= 1.5 && !this.m_9236_().f_46443_ && this.getAlterTime() <= 0) {
                this.setStalkDelay(-500);
                this.setAlterTime(100);
                AMIPacketHandler.FARSEER_ALTER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new AlterPacket());
                this.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                AMIUtils.awardAdvancement((Entity)player, "alterred", "alter");
            }
            if (this.getAlterTime() > 0) {
                if (this.f_19796_.m_188500_() < 0.05 && !this.m_9236_().f_46443_) {
                    for (int i = 0; i < 9; ++i) {
                        Inventory inv = player.m_150109_();
                        int j = this.m_217043_().m_216339_(0, 9);
                        ItemStack a = inv.m_8020_(i).m_41777_();
                        ItemStack b = inv.m_8020_(j).m_41777_();
                        inv.m_6836_(j, a);
                        inv.m_6836_(i, b);
                    }
                }
                this.setAlterTime(this.getAlterTime() - 1);
            }
        }
        if (this.getStalkDelay() == 0) {
            if (this.getStalkTime() > 0.0f) {
                this.setStalkTime(this.getStalkTime() - 0.01f);
            } else {
                this.setStalkTime(0.0f);
            }
        } else if (this.getStalkDelay() < 0) {
            this.setStalkDelay(this.getStalkDelay() + 1);
            if (this.getStalkTime() > 0.0f && this.getAlterTime() <= 0) {
                this.setStalkTime(this.getStalkTime() - 0.05f);
            } else if (this.getAlterTime() <= 0) {
                this.setStalkTime(0.0f);
            }
        } else {
            this.setStalkDelay(this.getStalkDelay() - 1);
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.SNAPPING_DORMANCY_ENABLED.get()).booleanValue() && player.m_21211_().m_41720_() instanceof SpyglassItem && (lookAt = AMIUtils.getClosestLookingAtEntityFor(player)) instanceof EntityAlligatorSnappingTurtle && ((AMIBaseInterfaces)(snappingTurtle = (EntityAlligatorSnappingTurtle)lookAt)).isDaySleeping()) {
            AMIUtils.awardAdvancement((Entity)player, "observe_dormancy", "observe");
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(FARSEER_ALTERRING_TIME, (Object)0);
        this.f_19804_.m_135372_(FARSEER_STALKING_TIME, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FARSEER_STALKING_DELAY, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("FarseerAlterringTime", this.getAlterTime());
        compound.m_128350_("FarseerStalkingTime", this.getStalkTime());
        compound.m_128405_("FarseerStalkingDelay", this.getStalkDelay());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setAlterTime(compound.m_128451_("FarseerAlterringTime"));
        this.setStalkTime(compound.m_128451_("FarseerStalkingTime"));
        this.setStalkDelay(compound.m_128451_("FarseerStalkingDelay"));
    }

    @Override
    public int getStalkDelay() {
        return (Integer)this.f_19804_.m_135370_(FARSEER_STALKING_DELAY);
    }

    @Override
    public void setStalkDelay(int time) {
        this.f_19804_.m_135381_(FARSEER_STALKING_DELAY, (Object)time);
    }

    @Override
    public float getStalkTime() {
        return ((Float)this.f_19804_.m_135370_(FARSEER_STALKING_TIME)).floatValue();
    }

    @Override
    public void setStalkTime(float time) {
        this.f_19804_.m_135381_(FARSEER_STALKING_TIME, (Object)Float.valueOf(time));
    }

    @Override
    public int getAlterTime() {
        return (Integer)this.f_19804_.m_135370_(FARSEER_ALTERRING_TIME);
    }

    @Override
    public void setAlterTime(int time) {
        this.f_19804_.m_135381_(FARSEER_ALTERRING_TIME, (Object)time);
    }
}

