/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.spout;

import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\b\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020\u0018H\u0002J\u001e\u00104\u001a\u00020\u00182\f\u00105\u001a\b\u0012\u0004\u0012\u0002060)2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0018\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0018H\u0014J\u0018\u0010<\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0018H\u0014J\u0011\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020?H\u0096\u0001J\u000b\u0010@\u001a\u0004\u0018\u00010AH\u0096\u0001J\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0096\u0001J\u0011\u0010E\u001a\u00020'2\u0006\u00109\u001a\u00020:H\u0096\u0001J\u0011\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020AH\u0096\u0001J\u0011\u0010H\u001a\u00020'2\u0006\u00109\u001a\u00020:H\u0096\u0001R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010!\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006I"}, d2={"Lio/github/cotrin8672/cem/content/block/spout/EnchantableSpoutBlockEntity;", "Lcom/simibubi/create/content/fluids/spout/SpoutBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "enchantedFillingTime", "", "getEnchantedFillingTime", "()I", "executionTick", "getExecutionTick", "spawnParticleTick", "getSpawnParticleTick", "fluidTank", "Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;", "getFluidTank", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;", "value", "", "createdSweetRoll", "getCreatedSweetRoll", "()Z", "setCreatedSweetRoll", "(Z)V", "createdHoneyApple", "getCreatedHoneyApple", "setCreatedHoneyApple", "createdChocolateBerries", "getCreatedChocolateBerries", "setCreatedChocolateBerries", "getCurrentFluidInTank", "Lnet/minecraftforge/fluids/FluidStack;", "addBehaviours", "", "behaviours", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "onItemReceived", "Lcom/simibubi/create/content/kinetics/belt/behaviour/BeltProcessingBehaviour$ProcessingResult;", "transported", "Lcom/simibubi/create/content/kinetics/belt/transport/TransportedItemStack;", "handler", "Lcom/simibubi/create/content/kinetics/belt/behaviour/TransportedItemStackHandlerBehaviour;", "whenItemHeld", "tick", "trackFoods", "addToGoggleTooltip", "tooltip", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "clientPacket", "write", "getEnchantmentLevel", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantmentTag", "Lnet/minecraft/nbt/ListTag;", "getEnchantments", "", "Lnet/minecraft/world/item/enchantment/EnchantmentInstance;", "readEnchantments", "setEnchantment", "listTag", "writeEnchantments", "createenchantablemachinery"})
public final class EnchantableSpoutBlockEntity
extends SpoutBlockEntity
implements EnchantableBlockEntity {
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableSpoutBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    @Override
    @NotNull
    public List<EnchantmentInstance> getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    @Nullable
    public ListTag getEnchantmentTag() {
        return this.$$delegate_0.getEnchantmentTag();
    }

    @Override
    public void setEnchantment(@NotNull ListTag listTag) {
        Intrinsics.checkNotNullParameter((Object)listTag, (String)"listTag");
        this.$$delegate_0.setEnchantment(listTag);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return ((EnchantableBlockEntity)this.$$delegate_0).getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.readEnchantments(compound);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.writeEnchantments(compound);
    }

    public final int getEnchantedFillingTime() {
        Enchantment enchantment = Enchantments.f_44984_;
        Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"BLOCK_EFFICIENCY");
        int efficiencyModifier = 2 * this.getEnchantmentLevel(enchantment);
        return Math.max(1, 20 - efficiencyModifier);
    }

    public final int getExecutionTick() {
        return Math.max(0, (int)Math.ceil((float)this.getEnchantedFillingTime() / 4.0f));
    }

    private final int getSpawnParticleTick() {
        return Math.max(0, this.getEnchantedFillingTime() * 2 / 5);
    }

    @NotNull
    public final SmartFluidTankBehaviour getFluidTank() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        SmartFluidTankBehaviour smartFluidTankBehaviour = ((SpoutBlockEntityMixin)((Object)this)).getTank();
        Intrinsics.checkNotNullExpressionValue((Object)smartFluidTankBehaviour, (String)"getTank(...)");
        return smartFluidTankBehaviour;
    }

    private final boolean getCreatedSweetRoll() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedSweetRoll();
    }

    private final void setCreatedSweetRoll(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedSweetRoll(value);
    }

    private final boolean getCreatedHoneyApple() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedHoneyApple();
    }

    private final void setCreatedHoneyApple(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedHoneyApple(value);
    }

    private final boolean getCreatedChocolateBerries() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        return ((SpoutBlockEntityMixin)((Object)this)).getCreatedChocolateBerries();
    }

    private final void setCreatedChocolateBerries(boolean value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SpoutBlockEntityMixin");
        ((SpoutBlockEntityMixin)((Object)this)).setCreatedChocolateBerries(value);
    }

    private final FluidStack getCurrentFluidInTank() {
        FluidStack fluidStack = this.getFluidTank().getPrimaryHandler().getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
        return fluidStack;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
    }

    @NotNull
    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(@NotNull TransportedItemStack transported, @NotNull TransportedItemStackHandlerBehaviour handler) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!FillingBySpout.canItemBeFilled((Level)this.f_58857_, (ItemStack)transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.getFluidTank().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)transported.stack, (FluidStack)this.getCurrentFluidInTank()) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    @NotNull
    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(@NotNull TransportedItemStack transported, @NotNull TransportedItemStackHandlerBehaviour handler) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (this.processingTicks != -1 && this.processingTicks != this.getExecutionTick()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (ItemStack)transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.getFluidTank().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (ItemStack)transported.stack, (FluidStack)fluid.copy());
        if (requiredAmountForItem == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = this.getEnchantedFillingTime();
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack out = FillingBySpout.fillItem((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (int)requiredAmountForItem, (ItemStack)transported.stack, (FluidStack)fluid);
        if (!out.m_41619_()) {
            List outList = new ArrayList();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.m_41619_()) {
                held = transported.copy();
            }
            Intrinsics.checkNotNull((Object)result);
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld((List)outList, (TransportedItemStack)held));
        }
        this.award(AllAdvancements.SPOUT);
        if (this.trackFoods()) {
            this.setCreatedChocolateBerries(this.getCreatedChocolateBerries() | AllItems.CHOCOLATE_BERRIES.isIn(out));
            this.setCreatedHoneyApple(this.getCreatedHoneyApple() | AllItems.HONEYED_APPLE.isIn(out));
            this.setCreatedSweetRoll(this.getCreatedSweetRoll() | AllItems.SWEET_ROLL.isIn(out));
            if (this.getCreatedChocolateBerries() && this.getCreatedHoneyApple() && this.getCreatedSweetRoll()) {
                this.award(AllAdvancements.FOODS);
            }
        }
        this.getFluidTank().getPrimaryHandler().setFluid(fluid);
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public void tick() {
        BlockEntityExtensionKt.smartBlockEntityTick((SmartBlockEntity)this);
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (!(this.processingTicks != -1 || !this.isVirtual() && BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this).m_5776_() || currentFluidInTank.isEmpty())) {
            BlockPos filling = this.f_58858_.m_6625_(2);
            BlockSpoutingBehaviour behaviour = BlockSpoutingBehaviour.get((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (BlockPos)filling);
            if (behaviour != null && behaviour.fillBlock(this.f_58857_, filling, (SpoutBlockEntity)this, currentFluidInTank.copy(), true) > 0) {
                this.processingTicks = this.getEnchantedFillingTime();
                this.customProcess = behaviour;
                this.notifyUpdate();
            }
        }
        if (this.processingTicks >= 0) {
            int filling = this.processingTicks;
            this.processingTicks = filling + -1;
            if (this.processingTicks == this.getExecutionTick() && this.customProcess != null) {
                int fillBlock = this.customProcess.fillBlock(this.f_58857_, this.f_58858_.m_6625_(2), (SpoutBlockEntity)this, currentFluidInTank.copy(), false);
                this.customProcess = null;
                if (fillBlock > 0) {
                    this.getFluidTank().getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - fillBlock)));
                    this.sendSplash = true;
                    this.notifyUpdate();
                }
            }
        }
        if (this.processingTicks >= this.getSpawnParticleTick() && BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).f_46443_) {
            this.spawnProcessingParticles(this.getFluidTank().getPrimaryTank().getRenderedFluid());
        }
    }

    private final boolean trackFoods() {
        return ((AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent();
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        for (EnchantmentInstance instance : this.getEnchantments()) {
            int level = instance.f_44948_;
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(instance.f_44947_.m_44700_(level).m_6881_()).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.readEnchantments(compound);
        super.read(compound, clientPacket);
    }

    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128473_("Enchantments");
        this.writeEnchantments(compound);
        super.write(compound, clientPacket);
    }
}

