/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.fan;

import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.AirCurrentSound;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import io.github.cotrin8672.cem.content.block.fan.EnchantableEncasedFanBlockEntity;
import io.github.cotrin8672.cem.content.block.fan.EnchantableFanProcessing;
import io.github.cotrin8672.cem.mixin.ServerGamePacketListenerImplMixin;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableAirCurrent;", "Lcom/simibubi/create/content/kinetics/fan/AirCurrent;", "source", "Lcom/simibubi/create/content/kinetics/fan/IAirCurrentSource;", "efficiencyLevel", "", "<init>", "(Lcom/simibubi/create/content/kinetics/fan/IAirCurrentSource;I)V", "fanProcessing", "Lio/github/cotrin8672/cem/content/block/fan/EnchantableFanProcessing;", "tickAffectedEntities", "", "world", "Lnet/minecraft/world/level/Level;", "tickAffectedHandlers", "AirCurrentSoundKt", "Client", "createenchantablemachinery"})
public final class EnchantableAirCurrent
extends AirCurrent {
    @NotNull
    private final EnchantableFanProcessing fanProcessing;

    public EnchantableAirCurrent(@NotNull IAirCurrentSource source, int efficiencyLevel) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
        this.fanProcessing = new EnchantableFanProcessing(efficiencyLevel);
    }

    protected void tickAffectedEntities(@Nullable Level world) {
        Iterator iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            FanProcessingType processingType;
            Entity entity = (Entity)iterator.next();
            if (!entity.m_6084_() || !entity.m_20191_().m_82381_(this.bounds) || AirCurrent.isPlayerCreativeFlying((Entity)entity)) {
                iterator.remove();
                continue;
            }
            Vec3i flow = (this.pushing ? this.direction : this.direction.m_122424_()).m_122436_();
            float speed = (float)Math.abs((double)this.source.getSpeed());
            float sneakModifier = entity.m_6144_() ? 4096.0f : 512.0f;
            double entityDistance = VecHelper.alignedDistanceToFace((Vec3)entity.m_20182_(), (BlockPos)this.source.getAirCurrentPos(), (Direction)this.direction);
            double entityDistanceOld = entity.m_20182_().m_82554_(VecHelper.getCenterOf((Vec3i)((Vec3i)this.source.getAirCurrentPos())));
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistanceOld / (double)this.maxDistance));
            Vec3 previousMotion = entity.m_20184_();
            double maxAcceleration = 5.0;
            double xIn = Mth.m_14008_((double)((double)((float)flow.m_123341_() * acceleration) - previousMotion.f_82479_), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.m_14008_((double)((double)((float)flow.m_123342_() * acceleration) - previousMotion.f_82480_), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.m_14008_((double)((double)((float)flow.m_123343_() * acceleration) - previousMotion.f_82481_), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.m_20256_(previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125)));
            entity.f_19789_ = 0.0f;
            if (CatnipServices.PLATFORM.getEnv().isClient()) {
                Intrinsics.checkNotNull((Object)entity);
                Client.INSTANCE.enableClientPlayerSound(entity, Mth.m_14036_((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f));
            }
            if (entity instanceof ServerPlayer) {
                ServerGamePacketListenerImpl serverGamePacketListenerImpl = ((ServerPlayer)entity).f_8906_;
                Intrinsics.checkNotNull((Object)serverGamePacketListenerImpl, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.ServerGamePacketListenerImplMixin");
                ServerGamePacketListenerImplMixin connection = (ServerGamePacketListenerImplMixin)serverGamePacketListenerImpl;
                connection.setAboveGroundTickCount(0);
            }
            if ((processingType = this.getTypeAt((float)entityDistance)) == null) continue;
            if (entity instanceof ItemEntity) {
                if (world != null && world.f_46443_) {
                    processingType.spawnProcessingParticles(world, ((ItemEntity)entity).m_20182_());
                    continue;
                }
                if (!this.fanProcessing.canProcess((ItemEntity)entity, processingType) || !this.fanProcessing.applyProcessing((ItemEntity)entity, processingType) || !(this.source instanceof EnchantableEncasedFanBlockEntity)) continue;
                IAirCurrentSource iAirCurrentSource = this.source;
                Intrinsics.checkNotNull((Object)iAirCurrentSource, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.content.block.fan.EnchantableEncasedFanBlockEntity");
                ((EnchantableEncasedFanBlockEntity)iAirCurrentSource).award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            if (world == null) continue;
            processingType.affectEntity(entity, world);
        }
    }

    public void tickAffectedHandlers() {
        for (Pair pair : this.affectedItemHandlers) {
            FanProcessingType processingType;
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            Level world = handler.getWorld();
            if ((FanProcessingType)pair.getRight() == null) continue;
            handler.handleProcessingOnAllItems(arg_0 -> EnchantableAirCurrent.tickAffectedHandlers$lambda$0(world, processingType, handler, this, arg_0));
        }
    }

    private static final TransportedItemStackHandlerBehaviour.TransportedResult tickAffectedHandlers$lambda$0(Level $world, FanProcessingType $processingType, TransportedItemStackHandlerBehaviour $handler, EnchantableAirCurrent this$0, TransportedItemStack transported) {
        Intrinsics.checkNotNullParameter((Object)$processingType, (String)"$processingType");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        if ($world.f_46443_) {
            $processingType.spawnProcessingParticles($world, $handler.getWorldPositionOf(transported));
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        }
        TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = this$0.fanProcessing.applyProcessing(transported, $world, $processingType);
        if (!applyProcessing.doesNothing() && this$0.source instanceof EnchantableEncasedFanBlockEntity) {
            IAirCurrentSource iAirCurrentSource = this$0.source;
            Intrinsics.checkNotNull((Object)iAirCurrentSource, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.content.block.fan.EnchantableEncasedFanBlockEntity");
            ((EnchantableEncasedFanBlockEntity)iAirCurrentSource).award(AllAdvancements.FAN_PROCESSING);
        }
        return applyProcessing;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableAirCurrent$AirCurrentSoundKt;", "Lcom/simibubi/create/content/kinetics/fan/AirCurrentSound;", "event", "Lnet/minecraft/sounds/SoundEvent;", "pitch", "", "<init>", "(Lnet/minecraft/sounds/SoundEvent;F)V", "createenchantablemachinery"})
    public static final class AirCurrentSoundKt
    extends AirCurrentSound {
        public AirCurrentSoundKt(@NotNull SoundEvent event, float pitch) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super(event, pitch);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableAirCurrent$Client;", "", "<init>", "()V", "isClientPlayerInAirCurrent", "", "flyingSound", "Lcom/simibubi/create/content/kinetics/fan/AirCurrentSound;", "enableClientPlayerSound", "", "e", "Lnet/minecraft/world/entity/Entity;", "maxVolume", "", "tickClientPlayerSounds", "createenchantablemachinery"})
    @SourceDebugExtension(value={"SMAP\nEnchantableAirCurrent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantableAirCurrent.kt\nio/github/cotrin8672/cem/content/block/fan/EnchantableAirCurrent$Client\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    public static final class Client {
        @NotNull
        public static final Client INSTANCE = new Client();
        private static boolean isClientPlayerInAirCurrent;
        @Nullable
        private static AirCurrentSound flyingSound;

        private Client() {
        }

        public final void enableClientPlayerSound(@NotNull Entity e, float maxVolume) {
            block6: {
                float pitch;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e != Minecraft.m_91087_().m_91288_()) {
                            return;
                        }
                        isClientPlayerInAirCurrent = true;
                        pitch = (float)Mth.m_14008_((double)(e.m_20184_().m_82553_() * (double)0.5f), (double)0.5, (double)2.0);
                        if (flyingSound == null) break block4;
                        AirCurrentSound airCurrentSound = flyingSound;
                        Intrinsics.checkNotNull((Object)airCurrentSound);
                        if (!airCurrentSound.m_7801_()) break block5;
                    }
                    SoundEvent soundEvent = SoundEvents.f_11886_;
                    Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ELYTRA_FLYING");
                    AirCurrentSound airCurrentSound = flyingSound = (AirCurrentSound)new AirCurrentSoundKt(soundEvent, pitch);
                    if (airCurrentSound != null) {
                        AirCurrentSound it = airCurrentSound;
                        boolean bl = false;
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)it);
                    }
                }
                AirCurrentSound airCurrentSound = flyingSound;
                if (airCurrentSound != null) {
                    airCurrentSound.setPitch(pitch);
                }
                AirCurrentSound airCurrentSound2 = flyingSound;
                if (airCurrentSound2 == null) break block6;
                airCurrentSound2.fadeIn(maxVolume);
            }
        }

        public final void tickClientPlayerSounds() {
            if (!isClientPlayerInAirCurrent && flyingSound != null) {
                AirCurrentSound airCurrentSound = flyingSound;
                boolean bl = airCurrentSound != null ? airCurrentSound.isFaded() : false;
                if (bl) {
                    AirCurrentSound airCurrentSound2 = flyingSound;
                    if (airCurrentSound2 != null) {
                        airCurrentSound2.stopSound();
                    }
                } else {
                    AirCurrentSound airCurrentSound3 = flyingSound;
                    if (airCurrentSound3 != null) {
                        airCurrentSound3.fadeOut();
                    }
                }
            }
            isClientPlayerInAirCurrent = false;
        }
    }
}

