/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class LogisticalStockResponsePacket
extends SimplePacketBase {
    private BlockPos pos;
    private List<BigItemStack> items;
    private boolean lastPacket;

    public LogisticalStockResponsePacket(boolean lastPacket, BlockPos pos, List<BigItemStack> items) {
        this.lastPacket = lastPacket;
        this.pos = pos;
        this.items = items;
    }

    public LogisticalStockResponsePacket(FriendlyByteBuf buffer) {
        this.lastPacket = buffer.readBoolean();
        this.pos = buffer.m_130135_();
        int count = buffer.m_130242_();
        this.items = new ArrayList<BigItemStack>(count);
        for (int i = 0; i < count; ++i) {
            this.items.add(BigItemStack.receive(buffer));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.lastPacket);
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.items.size());
        this.items.forEach(stack -> stack.send(buffer));
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (blockEntity instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
            stbe.receiveStockPacket(this.items, this.lastPacket);
        }
    }
}

