/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stock;

import com.simibubi.create.content.logistics.BigItemStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.key.item.ItemKey;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;

@Mixin(value={BigItemStack.class})
public class BigItemStackMixin
implements BigGenericStack {
    @Shadow(remap=false)
    public int count;
    @Shadow(remap=false)
    public ItemStack stack;
    @Unique
    private GenericStack createFactoryLogistics$stack;
    @Unique
    private ItemStack createFactoryLogistics$originalStack;

    public GenericStack get() {
        if (this.count != this.createFactoryLogistics$stack.amount()) {
            this.setAmount(this.count);
        }
        if (this.createFactoryLogistics$originalStack != this.stack) {
            this.set(GenericStack.wrap((ItemStack)this.stack).withAmount(this.count));
        }
        return this.createFactoryLogistics$stack;
    }

    public void set(GenericStack stack) {
        this.createFactoryLogistics$stack = stack;
        this.count = this.createFactoryLogistics$stack.amount();
        GenericKey genericKey = this.createFactoryLogistics$stack.key();
        if (genericKey instanceof ItemKey) {
            ItemKey itemKey = (ItemKey)genericKey;
            this.stack = itemKey.stack();
        } else if (this.createFactoryLogistics$stack.isEmpty()) {
            this.stack = ItemStack.f_41583_;
        }
        if (this.createFactoryLogistics$originalStack != this.stack) {
            this.createFactoryLogistics$originalStack = this.stack;
        }
    }

    public void setAmount(int count) {
        this.count = count;
        this.createFactoryLogistics$stack = this.createFactoryLogistics$stack.withAmount(count);
    }

    public BigItemStack asStack() {
        return (BigItemStack)this;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/item/ItemStack;I)V"}, at={@At(value="RETURN")}, remap=false)
    private void addIngredient(ItemStack stack, int count, CallbackInfo ci) {
        this.createFactoryLogistics$stack = GenericStack.wrap((ItemStack)stack).withAmount(count);
        this.createFactoryLogistics$originalStack = stack;
    }

    @Overwrite(remap=false)
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        GenericStackSerializer.write((GenericStack)this.createFactoryLogistics$stack, (CompoundTag)tag);
        return tag;
    }

    @Overwrite(remap=false)
    public static BigItemStack read(CompoundTag tag) {
        return BigGenericStack.of((GenericStack)GenericStackSerializer.read((CompoundTag)tag)).asStack();
    }

    @Overwrite(remap=false)
    public void send(FriendlyByteBuf buf) {
        GenericStackSerializer.write((GenericStack)this.createFactoryLogistics$stack, (FriendlyByteBuf)buf);
    }

    @Overwrite(remap=false)
    public static BigItemStack receive(FriendlyByteBuf buf) {
        return BigGenericStack.of((GenericStack)GenericStackSerializer.read((FriendlyByteBuf)buf)).asStack();
    }

    @Overwrite(remap=false)
    public boolean equals(Object obj) {
        BigGenericStack genericStack;
        return obj instanceof BigGenericStack && this.createFactoryLogistics$stack.equals((Object)(genericStack = (BigGenericStack)obj).get());
    }

    @Overwrite(remap=false)
    public int hashCode() {
        return this.createFactoryLogistics$stack.hashCode();
    }
}

