/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.shuffle.client;

import com.diontryban.ash.api.client.event.ClientTickEvents;
import com.diontryban.ash.api.client.input.KeyMappingRegistry;
import com.diontryban.ash.api.event.UseBlockEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;

public class ShuffleClient {
    private static final Random RANDOM = new Random();
    private static final KeyMapping KEY = KeyMappingRegistry.registerKeyMapping((ResourceLocation)new ResourceLocation("shuffle", "shuffle"), (int)82, (String)"shuffle");
    private static boolean shuffle = false;
    private static boolean keyWasDown = false;
    private static int slotToSwitchTo = -1;

    public static void init() {
        ClientTickEvents.registerStart(ShuffleClient::onClientStartTick);
        UseBlockEvent.register(ShuffleClient::onRightClickBlock);
    }

    private static void onClientStartTick(Minecraft client) {
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        if (KEY.m_90857_() && !keyWasDown) {
            keyWasDown = true;
            boolean bl = shuffle = !shuffle;
            if (shuffle) {
                player.m_5661_((Component)Component.m_237115_((String)"message.shuffle.enable"), true);
                player.m_5496_(SoundEvents.f_12523_, 0.5f, 1.0f);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.shuffle.disable"), true);
                player.m_5496_(SoundEvents.f_12524_, 0.5f, 1.0f);
            }
        } else if (!KEY.m_90857_() && keyWasDown) {
            keyWasDown = false;
        }
        if (slotToSwitchTo >= 0 && slotToSwitchTo <= 8) {
            player.m_150109_().f_35977_ = slotToSwitchTo;
            slotToSwitchTo = -1;
        }
    }

    private static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        Item itemInHand;
        if (shuffle && level.f_46443_ && !player.m_5833_() && Block.m_49814_((Item)(itemInHand = player.m_21120_(hand).m_41720_())) != Blocks.f_50016_) {
            ArrayList<Integer> slotsWithBlocks = new ArrayList<Integer>();
            NonNullList items = player.m_150109_().f_35974_;
            for (int i = 0; i <= 8; ++i) {
                Item item = ((ItemStack)items.get(i)).m_41720_();
                if (Block.m_49814_((Item)item) == Blocks.f_50016_) continue;
                slotsWithBlocks.add(i);
            }
            if (slotsWithBlocks.size() > 0) {
                slotToSwitchTo = (Integer)slotsWithBlocks.get(RANDOM.nextInt(slotsWithBlocks.size()));
            }
        }
        return InteractionResult.PASS;
    }
}

