/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash.impl.resource;

import com.diontryban.ash.api.resource.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;

public class ResourceLoaderImpl
extends ResourceLoader {
    private static final List<PreparableReloadListener> SERVER_RELOAD_LISTENERS = new ArrayList<PreparableReloadListener>();
    private final PackType type;

    public ResourceLoaderImpl() {
        this.type = null;
    }

    private ResourceLoaderImpl(PackType type) {
        this.type = type;
    }

    @Override
    public void registerReloadListenerImpl(PreparableReloadListener reloadListener) {
        if (this.type == PackType.CLIENT_RESOURCES) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            if (resourceManager instanceof ReloadableResourceManager) {
                ((ReloadableResourceManager)resourceManager).m_7217_(reloadListener);
            }
        } else if (this.type == PackType.SERVER_DATA) {
            if (SERVER_RELOAD_LISTENERS.isEmpty()) {
                MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListener);
            }
            SERVER_RELOAD_LISTENERS.add(reloadListener);
        }
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        for (PreparableReloadListener reloadListener : SERVER_RELOAD_LISTENERS) {
            event.addListener(reloadListener);
        }
    }

    @Override
    protected ResourceLoader getImpl(PackType type) {
        return new ResourceLoaderImpl(type);
    }
}

