/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.darkhax.bookshelf.mixin.accessors.world.AccessorStructureTemplatePool;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class StructureHelper {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public static StructurePoolElement singleElementFromNBT(RegistryAccess registryAccess, String nbtPath) {
        return StructureHelper.poolElementFromNBT(registryAccess, EMPTY_PROCESSOR_LIST_KEY, nbtPath, StructureTemplatePool.Projection.RIGID, false);
    }

    public static StructurePoolElement singleElementFromNBT(RegistryAccess registryAccess, ResourceKey<StructureProcessorList> processorId, String nbtPath) {
        return StructureHelper.poolElementFromNBT(registryAccess, processorId, nbtPath, StructureTemplatePool.Projection.RIGID, false);
    }

    public static StructurePoolElement singleElementFromNBT(RegistryAccess registryAccess, ResourceKey<StructureProcessorList> processorId, String nbtPath, StructureTemplatePool.Projection projection) {
        return StructureHelper.poolElementFromNBT(registryAccess, processorId, nbtPath, projection, false);
    }

    public static StructurePoolElement legacyElementFromNBT(RegistryAccess registryAccess, String nbtPath) {
        return StructureHelper.poolElementFromNBT(registryAccess, EMPTY_PROCESSOR_LIST_KEY, nbtPath, StructureTemplatePool.Projection.RIGID, true);
    }

    public static StructurePoolElement legacyElementFromNBT(RegistryAccess registryAccess, ResourceKey<StructureProcessorList> processorId, String nbtPath) {
        return StructureHelper.poolElementFromNBT(registryAccess, processorId, nbtPath, StructureTemplatePool.Projection.RIGID, true);
    }

    public static StructurePoolElement legacyElementFromNBT(RegistryAccess registryAccess, ResourceKey<StructureProcessorList> processorId, String nbtPath, StructureTemplatePool.Projection projection) {
        return StructureHelper.poolElementFromNBT(registryAccess, processorId, nbtPath, projection, true);
    }

    public static StructurePoolElement poolElementFromNBT(RegistryAccess registryAccess, ResourceKey<StructureProcessorList> processorId, String nbtPath, StructureTemplatePool.Projection projection, boolean useLegacy) {
        Holder.Reference processorList = ((Registry)registryAccess.m_6632_(Registries.f_257011_).orElseThrow()).m_246971_(processorId);
        return useLegacy ? (StructurePoolElement)SinglePoolElement.m_210512_((String)nbtPath, (Holder)processorList).apply(projection) : (StructurePoolElement)SinglePoolElement.m_210531_((String)nbtPath, (Holder)processorList).apply(projection);
    }

    public static void insertPoolElement(StructureTemplatePool pool, StructurePoolElement element, int weight) {
        if (pool instanceof AccessorStructureTemplatePool) {
            AccessorStructureTemplatePool poolAccessor = (AccessorStructureTemplatePool)pool;
            for (int i = 0; i < weight; ++i) {
                poolAccessor.bookshelf$getTemplates().add((Object)element);
            }
            if (poolAccessor.bookshelf$getRawTemplates().getClass() != ArrayList.class) {
                poolAccessor.bookshelf$setRawTemplates(new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.bookshelf$getRawTemplates()));
            }
            poolAccessor.bookshelf$getRawTemplates().add((Pair<StructurePoolElement, Integer>)new Pair((Object)element, (Object)weight));
        }
    }
}

